﻿using UnityEngine;
using System.Collections;

[RequireComponent (typeof(Camera))]
public class VHSPostProcessEffect : MonoBehaviour {
	Material m;
	public Shader shader;
	public MovieTexture VHS;

    public bool oldVHSEffect;
    public bool distortionEffect;

	float yScanline, xScanline;

	public void Start()
    {
        m = new Material(shader);
		m.SetTexture("_VHSTex", VHS);
		VHS.loop = true;
		VHS.Play();
	}

    void OnRenderImage(RenderTexture source, RenderTexture destination)
    {
        
        yScanline += Time.deltaTime * 0.1f;
		xScanline -= Time.deltaTime * 0.1f;

        if (yScanline >= 1)
        {
		    yScanline = Random.value;
		}
		if(xScanline <= 0.1f || Random.value < 1f)
        {
		    xScanline = Random.value;
		}

        if (distortionEffect)
        {
            m.SetFloat("_yScanline", yScanline);
            m.SetFloat("_xScanline", xScanline);
        }
		Graphics.Blit(source, destination, m);
        
		
	}
}