﻿using UnityEngine;
using System.Collections;

[RequireComponent (typeof (AudioSource))]
public class UISoundManager : MonoBehaviour {

    public AudioClip m_RoundWinnerSFX;
    public AudioClip m_MatchWinnerSFX;

    private AudioSource m_UIAudioSource;

    void Start()
    {
        m_UIAudioSource = gameObject.GetComponent<AudioSource>();
    }

    public void PlayRoundWinnerSFX()
    {
        m_UIAudioSource.clip = m_RoundWinnerSFX;
        m_UIAudioSource.Play();
    }

    public void PlayMatchWinnerSFX()
    {
        m_UIAudioSource.clip = m_MatchWinnerSFX;
        m_UIAudioSource.Play();
    }
}
