﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class UIMultiplayerConfig : MonoBehaviour
{
    public GameManager gameManager;

    public int playerCount;
    public Slider playerCountSlider;

    public UIMenuButtonColor[] buttonsColor;
    public Color[] playersColorArray;

    public int arenaID;
    public GameObject[] arenaLevels;

    // Use this for initialization
    void Start ()
    {
        playerCount = 2;
        UpdatePlayerCount();

        for(int i = 0; i< playerCount; i++)
        {
            UpdateColorSelection(i);
        }
    }

    public void UpdatePlayerCount(int forcedPlayerCount)
    {
        playerCount = forcedPlayerCount;
    }

    public void UpdatePlayerCount()
    {
        playerCount = Mathf.CeilToInt(playerCountSlider.value);

        switch (playerCount)
        {
            case 1:
                buttonsColor[0].gameObject.SetActive(true);
                buttonsColor[1].gameObject.SetActive(false);
                buttonsColor[2].gameObject.SetActive(false);
                buttonsColor[3].gameObject.SetActive(false);

                gameManager.m_Tanks.Clear();
                gameManager.m_Tanks.Add(new TankManager());
                gameManager.m_Tanks[0].m_SpawnPoint = gameManager.m_spawnPointsTransform[0];
                break;
            case 2:
                buttonsColor[0].gameObject.SetActive(true);
                buttonsColor[1].gameObject.SetActive(true);
                buttonsColor[2].gameObject.SetActive(false);
                buttonsColor[3].gameObject.SetActive(false);

                gameManager.m_Tanks.Clear();
                gameManager.m_Tanks.Add(new TankManager());
                gameManager.m_Tanks[0].m_SpawnPoint = gameManager.m_spawnPointsTransform[0];
                gameManager.m_Tanks.Add(new TankManager());
                gameManager.m_Tanks[1].m_SpawnPoint = gameManager.m_spawnPointsTransform[1];
                break;
            case 3:
                buttonsColor[0].gameObject.SetActive(true);
                buttonsColor[1].gameObject.SetActive(true);
                buttonsColor[2].gameObject.SetActive(true);
                buttonsColor[3].gameObject.SetActive(false);

                gameManager.m_Tanks.Clear();
                gameManager.m_Tanks.Add(new TankManager());
                gameManager.m_Tanks[0].m_SpawnPoint = gameManager.m_spawnPointsTransform[0];
                gameManager.m_Tanks.Add(new TankManager());
                gameManager.m_Tanks[1].m_SpawnPoint = gameManager.m_spawnPointsTransform[1];
                gameManager.m_Tanks.Add(new TankManager());
                gameManager.m_Tanks[2].m_SpawnPoint = gameManager.m_spawnPointsTransform[2];
                break;
            case 4:
                buttonsColor[0].gameObject.SetActive(true);
                buttonsColor[1].gameObject.SetActive(true);
                buttonsColor[2].gameObject.SetActive(true);
                buttonsColor[3].gameObject.SetActive(true);

                gameManager.m_Tanks.Clear();
                gameManager.m_Tanks.Add(new TankManager());
                gameManager.m_Tanks[0].m_SpawnPoint = gameManager.m_spawnPointsTransform[0];
                gameManager.m_Tanks.Add(new TankManager());
                gameManager.m_Tanks[1].m_SpawnPoint = gameManager.m_spawnPointsTransform[1];
                gameManager.m_Tanks.Add(new TankManager());
                gameManager.m_Tanks[2].m_SpawnPoint = gameManager.m_spawnPointsTransform[2];
                gameManager.m_Tanks.Add(new TankManager());
                gameManager.m_Tanks[3].m_SpawnPoint = gameManager.m_spawnPointsTransform[3];
                break;
            default:
                Debug.Log("Color Selection ERROR");
                break;
        }

        for (int i = 0; i < playerCount; i++)
        {
            UpdateColorSelection(i);
        }
    }

    public void UpdateColorSelection(int playerID)
    {
        playersColorArray[playerID] = buttonsColor[playerID].colorArray[buttonsColor[playerID].colorID];
        if(playerID < playerCount)
        {
            gameManager.m_Tanks[playerID].m_PlayerColor = playersColorArray[playerID];
        }
    }

    public void UpdateArenaID(int newArenaID)
    {
        arenaID = newArenaID;
        
        arenaLevels[0].SetActive(arenaID == 0);
        arenaLevels[1].SetActive(arenaID == 1);
        arenaLevels[2].SetActive(arenaID == 2);
        arenaLevels[3].SetActive(arenaID == 3);
        arenaLevels[4].SetActive(arenaID == 4);
    }
}
