﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class UIMenuButtonColor : MonoBehaviour
{

    public Color[] colorArray;
    public int colorID;
    private Button colorButton;

	void Awake ()
    {
        colorButton = gameObject.GetComponent<Button>();
    }

    void OnEnable()
    {
        colorID = Random.Range(0, colorArray.Length);
        colorButton.image.color = colorArray[colorID];
    }

    public void NextColor()
    {
        //Debug.Log(colorID);
        if(colorID == colorArray.Length - 1)
        {
            colorID = 0;
        }    
        else
        {
            colorID++;
        }    
        colorButton.image.color = colorArray[colorID];
    }
	
	
}
