﻿using UnityEngine;
using System.Collections;
using UnityEngine.UI;

public class UIIntro : MonoBehaviour {

    public Text textIntro;
    public Text textPressStart;
    public GameManager gameManager;

    void Start ()
    {
        textIntro.CrossFadeAlpha(0f, 0f, true);
        textPressStart.gameObject.SetActive(false);
        StartCoroutine("PlayIntroSequence");

        gameManager.isInIntro = true;
    }
	
	IEnumerator PlayIntroSequence()
    {
        yield return new WaitForSeconds(1f);
        textIntro.text = "IVI PRODUCTIONS IS PROUD TO PRESENT";
        textIntro.CrossFadeAlpha(1f, 1f, true);
        iTween.MoveTo(textIntro.gameObject, iTween.Hash("x", 0, "y", 0, "z", 0, "time", 4.0f, "easetype", iTween.EaseType.linear, "islocal", true));
        yield return new WaitForSeconds(2f);
        textIntro.CrossFadeAlpha(0f, 1f, true);

        yield return new WaitForSeconds(2.5f);
        textIntro.rectTransform.localPosition = new Vector3(0, 0, 250);
        textIntro.text = "A SPLITSCREEN COMPETITIVE GAME";
        textIntro.CrossFadeAlpha(1f, 1f, true);
        iTween.MoveTo(textIntro.gameObject, iTween.Hash("x", 0, "y", 0, "z", 0, "time", 4.0f, "easetype", iTween.EaseType.linear, "islocal", true));
        yield return new WaitForSeconds(2f);
        textIntro.CrossFadeAlpha(0f, 1f, true);

        yield return new WaitForSeconds(3.5f);
        textIntro.rectTransform.localPosition = new Vector3(0, 0, 250);
        textIntro.text = "GRID WARS";
        textIntro.CrossFadeAlpha(1f, 0.5f, true);
        iTween.MoveTo(textIntro.gameObject, iTween.Hash("x", 0, "y", 0, "z", 0, "time", 1.0f, "easetype", iTween.EaseType.linear, "islocal", true));

        yield return new WaitForSeconds(2.0f);

        while (true)
        {
            textPressStart.gameObject.SetActive(true);
            yield return new WaitForSeconds(1.0f);
            textPressStart.gameObject.SetActive(false);
            yield return new WaitForSeconds(0.25f);
        }
    }
}
