﻿using UnityEngine;
using System.Collections;

public class UICursor : MonoBehaviour {

    public Texture2D cursorTexture;
    public CursorMode cursorMode = CursorMode.Auto;
    public Vector2 hotSpot = Vector2.zero;

    void OnApplicationFocus(bool focusStatus)
    {
        if(focusStatus)
            Cursor.SetCursor(cursorTexture, hotSpot, cursorMode);
        else if(focusStatus)
            Cursor.SetCursor(null, Vector2.zero, cursorMode);
    }
}
