﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;
using XInputDotNetPure;

public class TankShooting : MonoBehaviour
{
    public int m_PlayerNumber = 1;
    public Rigidbody m_Shell;            
    public Transform m_FireTransform;    
    //public Slider m_AimSlider;
    public Slider m_ReloadSlider;        
    public AudioSource m_ShootingAudio;  
    public AudioClip m_ChargingClip;     
    public AudioClip m_FireClip;         
    public float m_MinLaunchForce = 15f; 
    public float m_MaxLaunchForce = 30f; 
    public float m_MaxChargeTime = 0.75f;

    public float timeBetweenFire = 2.0f;

    private string m_FireButton;
    private float m_CurrentLaunchForce;  
    private float m_ChargeSpeed;         
    private bool m_Fired;

    private bool m_canFire;

    private void OnEnable()
    {
        m_CurrentLaunchForce = m_MinLaunchForce;
        //m_AimSlider.value = m_MinLaunchForce;
        m_canFire = true;
        m_ReloadSlider.value = 1;
    }


    private void Start()
    {
        m_FireButton = "Fire" + m_PlayerNumber;

        m_ChargeSpeed = (m_MaxLaunchForce - m_MinLaunchForce) / m_MaxChargeTime;
    }
    

    private void Update()
    {
        // Track the current state of the fire button and make decisions based on the current launch force.
        //m_AimSlider.value = m_MinLaunchForce;
        if (m_CurrentLaunchForce >= m_MaxLaunchForce && !m_Fired)
        {
            // at max charge, not fired
            m_CurrentLaunchForce = m_MaxLaunchForce;
            Fire();
        }
        else if (Input.GetButtonDown(m_FireButton) && m_canFire)
        {
            // have we pressed the fire button for the first time ?
            m_Fired = false;
            m_CurrentLaunchForce = m_MinLaunchForce;
            m_ShootingAudio.clip = m_ChargingClip;
            m_ShootingAudio.Play();
        }
        else if (Input.GetButton(m_FireButton) && !m_Fired)
        {
            // holding the fire button, not yet fired
            m_CurrentLaunchForce += m_ChargeSpeed * Time.deltaTime;

            //m_AimSlider.value = m_CurrentLaunchForce;
        }
        else if (Input.GetButtonUp(m_FireButton) && !m_Fired)
        {
            // we released the button, having not fired yet
            Fire();
        }
    }


    private void Fire()
    {
        // Instantiate and launch the shell.
        m_Fired = true;
        StartCoroutine("FireLimiter");

        Rigidbody shellInstance = Instantiate(m_Shell, m_FireTransform.position, m_FireTransform.rotation) as Rigidbody;

        shellInstance.velocity = m_CurrentLaunchForce * m_FireTransform.forward;

        m_ShootingAudio.clip = m_FireClip;
        m_ShootingAudio.Play();

        m_CurrentLaunchForce = m_MinLaunchForce;

        //Make the controller of the player firing, the bigger the shot, the bigger the vibration
        PlayerIndex tankID = (PlayerIndex)gameObject.GetComponent<TankMovement>().m_PlayerNumber - 1;
        GamePadManager.Vibrate(tankID, 0.25f, 0.5f);
    }

    //ReloadSliderLimitation and animation
    IEnumerator FireLimiter()
    {
        m_ReloadSlider.value = 0;
        m_canFire = false;
        iTween.ValueTo(gameObject, iTween.Hash("from", 0f, "to", 1f, "time", timeBetweenFire, "onupdate", "updateSliderValue", "onupdatetarget", gameObject));
        yield return new WaitForSeconds(timeBetweenFire);
        m_canFire = true;
    }

    void updateSliderValue(float newValue)
    {
        m_ReloadSlider.value = newValue;
    }
}