﻿using UnityEngine;
using System;
using System.Collections;

[Serializable]
public class PowerUp : MonoBehaviour
{
    public enum m_PowerUpType { speed, agility, fireRate, firePower, heal };
    public m_PowerUpType m_powerUpType;
    public float m_powerUpDuration;

    public GameObject[] powerUpModels;

    public AudioClip speedAudioClip;
    public AudioClip agilityAudioClip;
    public AudioClip fireRateAudioClip;
    public AudioClip firePowerAudioClip;
    public AudioClip healAudioClip;
    private AudioSource powerUpAudioSource;

    void Awake()
    {
        powerUpAudioSource = gameObject.GetComponent<AudioSource>();

        //Setting a random type
        m_powerUpType = (m_PowerUpType) UnityEngine.Random.Range(0, Enum.GetNames(typeof(m_PowerUpType)).Length);
        
        //Setting the powerup model to match the type
        GameObject model;
        switch (m_powerUpType)
        {
            case m_PowerUpType.speed:
                model = Instantiate(powerUpModels[0], gameObject.transform.position, Quaternion.Euler(-90,0,0)) as GameObject;
                model.transform.parent = gameObject.transform;
                break;
            case m_PowerUpType.agility:
                model = Instantiate(powerUpModels[1], gameObject.transform.position, Quaternion.Euler(-90, 0, 0)) as GameObject;
                model.transform.parent = gameObject.transform;
                break;
            case m_PowerUpType.fireRate:
                model = Instantiate(powerUpModels[2], gameObject.transform.position, Quaternion.Euler(-90, 0, 0)) as GameObject;
                model.transform.parent = gameObject.transform;
                break;
            case m_PowerUpType.firePower:
                model = Instantiate(powerUpModels[3], gameObject.transform.position, Quaternion.Euler(-90, 0, 0)) as GameObject;
                model.transform.parent = gameObject.transform;
                break;
            case m_PowerUpType.heal:
                model = Instantiate(powerUpModels[4], gameObject.transform.position, Quaternion.Euler(-90, 0, 0)) as GameObject;
                model.transform.parent = gameObject.transform;
                break;
            default:
                break;
        }

        //powerUp Animation
        iTween.MoveTo(gameObject, iTween.Hash("islocal", true, "y", 1, "time", 1.0f, "looptype", iTween.LoopType.pingPong, "easetype", iTween.EaseType.easeInOutSine));
        iTween.RotateBy(gameObject, iTween.Hash("islocal", true, "y", 1, "time", 4.0f, "looptype", iTween.LoopType.loop, "easetype", iTween.EaseType.linear));
    }

    void OnTriggerEnter(Collider other)
    {
        if(other.tag == "Player")
        {
            switch(m_powerUpType)
            {
                case m_PowerUpType.speed:
                    StartCoroutine("BoostSpeed", other.gameObject);
                    break;
                case m_PowerUpType.agility:
                    StartCoroutine("BoostAgility", other.gameObject);
                    break;
                case m_PowerUpType.fireRate:
                    StartCoroutine("BoostFireRate", other.gameObject);
                    break;
                case m_PowerUpType.firePower:
                    StartCoroutine("BoostFirePower", other.gameObject);
                    break;
                case m_PowerUpType.heal:
                    BoostFirePower(other.gameObject);
                    StartCoroutine("HealPlayer", other.gameObject);
                    break;
                default:
                    break;
            }
            gameObject.GetComponentInChildren<Renderer>().enabled = false;
            gameObject.GetComponent<Collider>().enabled = false;
            Destroy(gameObject, m_powerUpDuration + 1);

            //Debug.Log("Set " + transform.parent.name + " usable true");
            transform.parent.GetComponent<SpawnPointProperties>().isUsable = true;
        }
    }

    IEnumerator BoostSpeed(GameObject playerGo)
    {
        powerUpAudioSource.PlayOneShot(speedAudioClip);

        playerGo.transform.GetChild(0).transform.GetChild(1).gameObject.SetActive(true);
        playerGo.GetComponent<TankMovement>().m_Speed += 25;
        yield return new WaitForSeconds(m_powerUpDuration);
        playerGo.transform.GetChild(0).transform.GetChild(1).gameObject.SetActive(false);
        playerGo.GetComponent<TankMovement>().m_Speed -= 25;

    }

    IEnumerator BoostFirePower(GameObject playerGo)
    {
        powerUpAudioSource.PlayOneShot(firePowerAudioClip);

        playerGo.transform.GetChild(0).transform.GetChild(3).gameObject.SetActive(true);
        playerGo.GetComponent<TankShooting>().m_MinLaunchForce += 50;
        playerGo.GetComponent<TankShooting>().m_MaxLaunchForce += 50;
        yield return new WaitForSeconds(m_powerUpDuration);
        playerGo.transform.GetChild(0).transform.GetChild(3).gameObject.SetActive(false);
        playerGo.GetComponent<TankShooting>().m_MinLaunchForce -= 50;
        playerGo.GetComponent<TankShooting>().m_MaxLaunchForce -= 50;
    }

    IEnumerator BoostFireRate(GameObject playerGo)
    {
        powerUpAudioSource.PlayOneShot(fireRateAudioClip);

        playerGo.transform.GetChild(0).transform.GetChild(4).gameObject.SetActive(true);
        playerGo.GetComponent<TankShooting>().timeBetweenFire -= 1;
        yield return new WaitForSeconds(m_powerUpDuration);
        playerGo.transform.GetChild(0).transform.GetChild(4).gameObject.SetActive(false);
        playerGo.GetComponent<TankShooting>().timeBetweenFire += 1;
    }

    IEnumerator HealPlayer(GameObject playerGo)
    {
        powerUpAudioSource.PlayOneShot(healAudioClip);

        playerGo.transform.GetChild(0).transform.GetChild(0).gameObject.SetActive(true);
        playerGo.GetComponent<TankHealth>().m_CurrentHealth += 50;
        playerGo.GetComponent<TankHealth>().SetHealthUI();
        yield return new WaitForSeconds(m_powerUpDuration);
        playerGo.transform.GetChild(0).transform.GetChild(0).gameObject.SetActive(false);
    }

    IEnumerator BoostAgility(GameObject playerGo)
    {
        powerUpAudioSource.PlayOneShot(agilityAudioClip);

        playerGo.transform.GetChild(0).transform.GetChild(2).gameObject.SetActive(true);
        playerGo.GetComponent<TankMovement>().m_TurnSpeed += 25;
        playerGo.GetComponent<TankMovement>().m_TurretTurnSpeed += 25;
        yield return new WaitForSeconds(m_powerUpDuration);
        playerGo.transform.GetChild(0).transform.GetChild(2).gameObject.SetActive(false);
        playerGo.GetComponent<TankMovement>().m_TurnSpeed -= 25;
        playerGo.GetComponent<TankMovement>().m_TurretTurnSpeed -= 25;
    }
}
