﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class SplitscreenManager : MonoBehaviour
{

	public GameManager m_gameManager;
	public GameObject m_cameraPrefab;

    public GameObject m_fillCamera;

    [HideInInspector]
    public List<GameObject> m_cameraList = new List<GameObject>();

    void Start()
    {
        m_fillCamera.SetActive(false);
    }

	// Use this for camera initialization
	public void SetupCameras ()
	{
        for (int i = 0; i < m_gameManager.m_Tanks.Count; i++)
		{
            m_cameraList.Add(Instantiate(m_cameraPrefab,
                            m_gameManager.m_Tanks[i].m_SpawnPoint.position,
                            m_gameManager.m_Tanks[i].m_SpawnPoint.rotation) as GameObject);

			m_cameraList[i].name = "Camera_Player_" + (i + 1);
            m_cameraList[i].GetComponent<SmoothFollow>().target = m_gameManager.m_Tanks[i].m_Instance.transform.GetChild(1).transform;
        }

        switch(m_cameraList.Count)
        {
            case 1:
                m_cameraList[0].GetComponent<Camera>().rect = new Rect(0f, 0f, 1f, 1f);
                break;
            case 2:
                m_cameraList[0].GetComponent<Camera>().rect = new Rect(0f, 0f, 0.5f, 1f);
                m_cameraList[1].GetComponent<Camera>().rect = new Rect(0.5f, 0f, 0.5f, 1f);
                break;
            case 3:
                m_cameraList[0].GetComponent<Camera>().rect = new Rect(0f, 0.5f, 0.5f, 0.5f);
                m_cameraList[1].GetComponent<Camera>().rect = new Rect(0.5f, 0.5f, 0.5f, 0.5f);
                m_cameraList[2].GetComponent<Camera>().rect = new Rect(0f, 0f, 0.5f, 0.5f);
                m_fillCamera.SetActive(true);
                break;
            case 4:
                m_cameraList[0].GetComponent<Camera>().rect = new Rect(0f, 0.5f, 0.5f, 0.5f);
                m_cameraList[1].GetComponent<Camera>().rect = new Rect(0.5f, 0.5f, 0.5f, 0.5f);
                m_cameraList[2].GetComponent<Camera>().rect = new Rect(0f, 0f, 0.5f, 0.5f);
                m_cameraList[3].GetComponent<Camera>().rect = new Rect(0.5f, 0f, 0.5f, 0.5f);
                break;
            default:
                Debug.Log("NoTank and Camera !");
                break;
        }
	}
}
