﻿using UnityEngine;
using System.Collections;

public class RandomPitch : MonoBehaviour {

    public float minTimeBetweenShift;
    public float maxTimeBetweenShift;
    public float minPitch;
    public float maxPitch;
    public float minPitchDuration;
    public float maxPitchDuration;
    AudioSource audioSource;
	
	void Start()
    {
        audioSource = gameObject.GetComponent<AudioSource>();
        StartCoroutine("ShiftPitch");
    }

    IEnumerator ShiftPitch()
    {
        while (true)
        {
            yield return new WaitForSeconds(Random.Range(minTimeBetweenShift, maxTimeBetweenShift));
            audioSource.pitch = Random.Range(minPitch, maxPitch);
            yield return new WaitForSeconds(Random.Range(minPitchDuration, maxPitchDuration));
            audioSource.pitch = 1;
        }
    }
}
