﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class SourisController : MonoBehaviour 
{

    private float rotationXAxis = 0.0f;
    private float rotationYAxis = 0.0f;

    private float sensitivityRotate = 5f;
	public float sensitivityZoom= 0.01f;

    private float panSpeed = 1.0f;
	public float scrollMax = -5f;
	public float scrollMin = -1000f;

    private float scrollMaxVueSimu = 100f;
    private float scrollMinVueSimu = 3.2f;

    public bool isRotating;
	public bool isPanning;
	public bool isZoom;
    public GameObject ControlCamera;
    
	public Transform CameraUpDownRot;
	public Transform vue3D, vueSimu;

	public Transform cam_target;
    private Transform cam;
	public Camera cam_cam;
    private bool allowCamInput;



	// Use this for initialization
	void Start () 
	{
        allowCamInput = true;
        cam = Camera.main.transform;
		SetVue(0);
		cam_cam = cam.GetComponent<Camera>();
		cam_cam.orthographicSize = 20;
	}
	
	// Update is called once per frame
	void LateUpdate () 
	{
        if(allowCamInput)
        {
            CamInput();
        }
		
		if (Input.GetKeyDown (KeyCode.F1)) 
		{
			SetVue(0);
		}
        if (Input.GetKeyDown (KeyCode.F2)) 
		{
			SetVue(2);
		}
        if (Input.GetKeyDown(KeyCode.F3))
        {
            ControlCamera.transform.localPosition = Vector3.zero;
        }

        cam.position = Vector3.Lerp(cam.position, cam_target.position, 0.5f);
		cam.rotation = Quaternion.Slerp(cam.rotation, cam_target.rotation, 0.5f);
	}

	void CamInput(){
		
		
		if (Input.GetAxis("Mouse ScrollWheel") != 0 && !isPanning && !isRotating)
		{
			isZoom = true; 
		}
		if (Input.GetAxis("Mouse ScrollWheel") == 0)
		{
			isZoom = false;
		}
		if (isZoom)
		{
			Zoom();
		}
		if (Input.GetMouseButtonDown(1) && !isPanning)
		{
			isRotating = true;
   		}
		if (isRotating)
		{
			RotationCamera();
		}
        if (Input.GetMouseButtonUp(1))
        {
            isRotating = false;
        }
		if(Input.GetMouseButtonDown(2) && !isRotating && cam_target != vueSimu)
		{
			isPanning = true;
		}
		if (isPanning)
		{
			DeplacementCamera();
		}
        if (Input.GetMouseButtonUp(2))
        {
            isPanning = false;
        }
	}


	public void SetVue(int vue)
	{

		// si 0 : vue 3d, si 2 : vue Simu
		if (vue == 0) 
		{
            cam.GetComponent<UnityStandardAssets.ImageEffects.VignetteAndChromaticAberration>().enabled = false;
            cam_target = vue3D;
			cam_cam.orthographic = false;
		}
        
		if (vue == 2) 
		{
            ControlCamera.transform.localPosition = new Vector3(0, 0, 0);
            vueSimu.transform.localPosition = new Vector3(0, 3.6f, 2.5f);
            cam.GetComponent<UnityStandardAssets.ImageEffects.VignetteAndChromaticAberration>().enabled = true;
            cam_target = vueSimu;
			cam_cam.orthographic = false;
		}
	}

	void RotationCamera()
	{
		// Rotation autour de l'axe X et Y avec le clic droit

		rotationXAxis += Input.GetAxis("Mouse Y") * -sensitivityRotate;
		rotationXAxis = Mathf.Clamp (rotationXAxis, 10, 60);
		CameraUpDownRot.localEulerAngles = new Vector3(rotationXAxis, CameraUpDownRot.localEulerAngles.y, CameraUpDownRot.localEulerAngles.z);

		rotationYAxis = ControlCamera.transform.localEulerAngles.y;
		rotationYAxis += Input.GetAxis("Mouse X") * sensitivityRotate;
		transform.localEulerAngles = new Vector3(transform.localEulerAngles.x, rotationYAxis, transform.localEulerAngles.z);
	}
	void DeplacementCamera()
	{
        // Deplacement de la camera sur le plan XZ en appuyant sur la molette
        ControlCamera.transform.position += transform.TransformVector ((new Vector3 (Input.GetAxis("Mouse X"), 0, Input.GetAxis("Mouse Y"))) * -panSpeed);
	}
	void Zoom()
	{
		// Zoom avec la molette de la souris
		if (cam_target == vue3D) 
		{
			cam_target.position += transform.forward * sensitivityZoom * (Input.GetAxis ("Mouse ScrollWheel"))* 3f *(cam_target.localPosition.z * cam_target.localPosition.z);
		
			float mon_z = cam_target.localPosition.z;
			if (mon_z > scrollMax) 
				mon_z = scrollMax;

			if (mon_z < scrollMin) 
				mon_z = scrollMin;
			
			Vector3 newPos = new Vector3 (0, 0, mon_z);
			cam_target.localPosition = newPos;
		}
        
		if (cam_target == vueSimu) 
		{
            cam_target.localPosition += transform.forward * sensitivityZoom * (Input.GetAxis("Mouse ScrollWheel")) * 5f * (cam_target.localPosition.z * cam_target.localPosition.z);
            
            float mon_z = cam_target.localPosition.z;
            Debug.Log(mon_z);
            if (mon_z > scrollMaxVueSimu)
                mon_z = scrollMaxVueSimu;

            if (mon_z < scrollMinVueSimu)
                mon_z = scrollMinVueSimu;

            Vector3 newPos = new Vector3(0, 3.6f, mon_z);
            cam_target.localPosition = newPos;
         }
	}
}