﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class PlayerManager : MonoBehaviour
{
    public float speed;               // valeur entre -X et X
    const int SPEED_MAX = 4;        // valeur Max
    float speedInertie = 1.0f;      // inertie bateau 

    float speedFanValue = 0.0f;     // inertie des helices

    int rotGouv;                    // Angle du gouvernail entre -40 et 40
    const int ROTATION_MAX = 40;    // valeur Max

    public Rigidbody battleshipRigidBody;

    public GameObject heliceAvTribord;
    public GameObject heliceArTribord;
    public GameObject heliceAvBabord;
    public GameObject heliceArBabord;
    public GameObject radar;
    public GameObject gouvernail;

    private bool wasAvancing = false;
    private bool justStopped = false;

    //effet eau
    public GameObject splashAvant1;
    public GameObject splashAvant2;
    public GameObject traineeAvant1;
    public GameObject traineeAvant2;
    public GameObject trainee;

    public ParticleSystem splashAv1;
    public ParticleSystem splashAv2;
    public ParticleSystem traineeAv1;
    public ParticleSystem traineeAv2;
    public ParticleSystem traineeBateau;

    public Text VitesseDuBateau;

    // Use this for initialization
    void Start ()
    {
        speed = 0;
        rotGouv = 0;

        //desactivation des effets d'eau
        /*splashAvant1.SetActive(false);
        splashAvant2.SetActive(false);
        traineeAvant1.SetActive(false);
        traineeAvant2.SetActive(false);
        trainee.SetActive(false);*/

        splashAv1.Pause();
        splashAv2.Pause();
        traineeAv1.Pause();
        traineeAv2.Pause();
        traineeBateau.Pause();

    }
	
	// Update is called once per frame
	void Update ()
    {
        // Déplacement bateau............................................
        
        float realRotation = rotGouv / (Mathf.Abs((float)(speed)) + 1);

        if (speed != 0)
        {
            transform.Translate(0.0f, 0.0f, speed /2 * Time.deltaTime);
            transform.Rotate(0, realRotation * 0.4f * Time.deltaTime, 0.0f);
        }

        if (justStopped)
        {
            speedInertie *= 0.99f;
            // Si on avançait, alors le translate est positif, si on reculait, il est négatif
            transform.Translate(0.0f, 0.0f, speedInertie * (wasAvancing ? 1 : -1) * Time.deltaTime);
        }
        
        //Debug.Log("inertie : " + speedInertie);
        //Debug.Log("speed : " + speed);

        //Marche avant
        if (Input.GetKeyDown(KeyCode.KeypadPlus) && speed < SPEED_MAX)
        {
            speed++;
            if (!justStopped && speed == 0)
            {
                // Si on vient tout juste de s'arrêter, on remet l'inertie à 1
                speedInertie = 1;
            }
            justStopped = (speed == 0); // On vient de s'arrêter si la vitesse vient d'être à 0
            if (justStopped)
            {
                wasAvancing = false; // Si on vient de s'arrêter alors qu'on a voulu accélérer, c'est qu'on reculait
            }
        }

        //Marche arriere
        if (Input.GetKeyDown(KeyCode.KeypadMinus) && speed > -SPEED_MAX /2)
        {
            speed--;
            if (!justStopped && speed == 0)
            {
                // Si on vient tout juste de s'arrêter, on remet l'inertie à 1
                speedInertie = 1;
            }
            justStopped = (speed == 0); // On vient de s'arrêter si la vitesse vient d'être à 0
            if (justStopped)
            {
                wasAvancing = true; // Si on vient de s'arrêter alors qu'on a voulu ralentir, on avançait
            }
        }

        // direction bateau
        if (Input.GetKey(KeyCode.LeftArrow) && rotGouv > -ROTATION_MAX)
        {
            // Gauche
            rotGouv--;
        }
        else if (Input.GetKey(KeyCode.RightArrow) && rotGouv < ROTATION_MAX)
        {
            // Droite
            rotGouv++;
        }
        else
        {
            if (rotGouv > 0)
            {
                rotGouv--;
            }
            else if (rotGouv < 0)
            {
                rotGouv++;
            }
        }
        
        if (speed >=0)
        {
            gouvernail.transform.localRotation = Quaternion.Euler(-90, -realRotation, 0);
        }

        if (speed > 0)
        {
            /*splashAvant1.SetActive(true);
            splashAvant2.SetActive(true);
            traineeAvant1.SetActive(true);
            traineeAvant2.SetActive(true);
            trainee.SetActive(true);*/

            splashAv1.Play();
            splashAv2.Play();
            traineeAv1.Play();
            traineeAv2.Play();
            traineeBateau.Play();
        }

        if (speed < 0)
        {
            gouvernail.transform.localRotation = Quaternion.Euler(-90, realRotation, 0);

            splashAvant1.SetActive(false);
            splashAvant2.SetActive(false);
            traineeAvant1.SetActive(false);
            traineeAvant2.SetActive(false);
            trainee.SetActive(false);
        }

        //vitesse effets eau
        if (speed == 0)
        {
            /*splashAv1.startSpeed = 0.0f;
            splashAv2.startSpeed = 0.40f; ;
            traineeAv1.startSpeed = 0.0f; ;
            traineeAv2.startSpeed = 0.4f; ;
            traineeBateau.startSpeed = 0.4f;*/

            /*splashAvant1.SetActive(false);
            splashAvant2.SetActive(false);
            traineeAvant1.SetActive(false);
            traineeAvant2.SetActive(false);
            trainee.SetActive(false);*/

            /*splashAv1.Stop();
            splashAv2.Stop();
            traineeAv1.Stop();
            traineeAv2.Stop();
            traineeBateau.Stop();
            */
            splashAv1.Emit(0);
            splashAv2.Emit(0);
            traineeAv1.Emit(0);
            traineeAv2.Emit(0);
            traineeBateau.Emit(0);

        }

        if (speed == 1)
        {
            /*splashAv1.Play();
            splashAv2.Play();
            traineeAv1.Play();
            traineeAv2.Play();
            traineeBateau.Play();*/

            splashAv1.Emit(1);
            splashAv2.Emit(1);
            traineeAv1.Emit(1);
            traineeAv2.Emit(1);
            traineeBateau.Emit(1);

            splashAv1.startSpeed = 0.5f;
            splashAv2.startSpeed = 0.5f; ;
            traineeAv1.startSpeed = 0.5f; ;
            traineeAv2.startSpeed = 0.5f; ;
            traineeAv1.startSize = 6.0f;
            traineeAv2.startSize = 6.0f;
            traineeBateau.startSpeed = 0.5f;
        }

        if (speed == 2)
        {
            splashAv1.startSpeed = 1.0f;
            splashAv2.startSpeed = 1.0f; ;
            traineeAv1.startSpeed = 1.0f; ;
            traineeAv2.startSpeed = 1.0f; ;
            traineeAv1.startSize = 12.0f;
            traineeAv2.startSize = 12.0f;
            traineeBateau.startSpeed = 1.0f;
        }



        // helices...............................................................................

        if (Mathf.Abs(speed) >= 1)
        {
            speedFanValue = speed;
        }

        heliceAvTribord.transform.Rotate(Vector3.forward, speedFanValue * 500 * Time.deltaTime);
        heliceArTribord.transform.Rotate(Vector3.forward, speedFanValue * 500 * Time.deltaTime);
        heliceAvBabord.transform.Rotate(Vector3.forward, -speedFanValue * 500 * Time.deltaTime);
        heliceArBabord.transform.Rotate(Vector3.forward, -speedFanValue * 500 * Time.deltaTime);

        speedFanValue *= 0.99f;

        radar.transform.Rotate(Vector3.forward, 20 * Time.deltaTime);

        //Debug.Log(rotGouv);
        //-----------------------------Affichage vitesse sur l'interfaçe-------------------------------------
        if (speed == -2)
        {
            VitesseDuBateau.text = "Vitesse : " + speed * 6 +"Nds";
        }
        if (speed==-1)
        {
            VitesseDuBateau.text = "Vitesse : " + speed*6 + "Nds";
        }
        if (speed == 0)
        {
            VitesseDuBateau.text = "Vitesse : " + speed + "Nds";
        }
        if (speed == 1)
        {
            VitesseDuBateau.text = "Vitesse : " + speed * 8 + "Nds";
        }
        if (speed == 2)
        {
            VitesseDuBateau.text = "Vitesse : " + speed * 8 + "Nds";
        }
        if (speed == 3)
        {
            VitesseDuBateau.text = "Vitesse : " + speed * 7 + "Nds";
        }
        if (speed == 4)
        {
            VitesseDuBateau.text = "Vitesse : " + speed * 6 + "Nds";
        }

    }
}
