﻿using UnityEngine;
using System.Collections;

public class IAManager : MonoBehaviour
{
    public float speed;             // valeur entre -X et X
    const int SPEED_MAX = 2;        // valeur Max
    float speedInertie = 1.0f;      // inertie bateau 

    float speedFanValue = 0.0f;     // inertie des helices

    public Rigidbody battleshipRigidBody;

    public GameObject heliceAvTribord;
    public GameObject heliceArTribord;
    public GameObject heliceAvBabord;
    public GameObject heliceArBabord;
    public GameObject radar;

    private bool wasAvancing = false;
    private bool justStopped = false;

    public bool onRange = false;

    public AudioSource iaEngine;

    //effet eau
    /*public GameObject splashAvant1;
    public GameObject splashAvant2;
    public GameObject traineeAvant1;
    public GameObject traineeAvant2;
    public GameObject trainee;*/

    /*public ParticleSystem splashAv1;
    public ParticleSystem splashAv2;
    public ParticleSystem traineeAv1;
    public ParticleSystem traineeAv2;
    public ParticleSystem traineeBateau;*/

    // Use this for initialization
    void Start ()
    {
        iaEngine.Play();
        speed = 2;
        //desactivation des effets d'eau
        /*splashAvant1.SetActive(false);
        splashAvant2.SetActive(false);
        traineeAvant1.SetActive(false);
        traineeAvant2.SetActive(false);
        trainee.SetActive(false);*/

        /*splashAv1.Pause();
        splashAv2.Pause();
        traineeAv1.Pause();
        traineeAv2.Pause();
        traineeBateau.Pause();*/

    }
	
	// Update is called once per frame
	void Update ()
    {
        // Déplacement bateau............................................
        if (speed != 0)
        {
            transform.Translate(0.0f, 0.0f, speed / 2 * Time.deltaTime);
        }

        if (justStopped)
        {
            speedInertie *= 0.99f;
            // Si on avançait, alors le translate est positif, si on reculait, il est négatif
            transform.Translate(0.0f, 0.0f, speedInertie * (wasAvancing ? 1 : -1) * Time.deltaTime);
        }
        
        //Debug.Log("inertie : " + speedInertie);
        //Debug.Log("speed : " + speed);

        //Marche avant

            if (!justStopped && speed == 0)
            {
                // Si on vient tout juste de s'arrêter, on remet l'inertie à 1
                speedInertie = 1;
            }
            justStopped = (speed == 0); // On vient de s'arrêter si la vitesse vient d'être à 0
            if (justStopped)
            {
                wasAvancing = false; // Si on vient de s'arrêter alors qu'on a voulu accélérer, c'est qu'on reculait
            }
       
        if (speed > 0)
        {
            /*splashAvant1.SetActive(true);
            splashAvant2.SetActive(true);
            traineeAvant1.SetActive(true);
            traineeAvant2.SetActive(true);
            trainee.SetActive(true);*/

            /*splashAv1.Play();
            splashAv2.Play();
            traineeAv1.Play();
            traineeAv2.Play();
            traineeBateau.Play();*/
        }

        //vitesse effets eau
        if (speed == 0)
        {
            /*splashAv1.startSpeed = 0.0f;
            splashAv2.startSpeed = 0.40f; ;
            traineeAv1.startSpeed = 0.0f; ;
            traineeAv2.startSpeed = 0.4f; ;
            traineeBateau.startSpeed = 0.4f;*/

            /*splashAvant1.SetActive(false);
            splashAvant2.SetActive(false);
            traineeAvant1.SetActive(false);
            traineeAvant2.SetActive(false);
            trainee.SetActive(false);*/

            /*splashAv1.Stop();
            splashAv2.Stop();
            traineeAv1.Stop();
            traineeAv2.Stop();
            traineeBateau.Stop();
            */
            /*splashAv1.Emit(0);
            splashAv2.Emit(0);
            traineeAv1.Emit(0);
            traineeAv2.Emit(0);
            traineeBateau.Emit(0);*/

        }

        if (speed == 2)
        {
            /*splashAv1.startSpeed = 1.0f;
            splashAv2.startSpeed = 1.0f; ;
            traineeAv1.startSpeed = 1.0f; ;
            traineeAv2.startSpeed = 1.0f; ;
            traineeAv1.startSize = 12.0f;
            traineeAv2.startSize = 12.0f;
            traineeBateau.startSpeed = 1.0f;*/
        }
        
        // helices...............................................................................

        if (Mathf.Abs(speed) >= 1)
        {
            speedFanValue = speed;
        }

        heliceAvTribord.transform.Rotate(Vector3.forward, speedFanValue * 500 * Time.deltaTime);
        heliceArTribord.transform.Rotate(Vector3.forward, speedFanValue * 500 * Time.deltaTime);
        heliceAvBabord.transform.Rotate(Vector3.forward, -speedFanValue * 500 * Time.deltaTime);
        heliceArBabord.transform.Rotate(Vector3.forward, -speedFanValue * 500 * Time.deltaTime);

        speedFanValue *= 0.99f;

        radar.transform.Rotate(Vector3.forward, 20 * Time.deltaTime);


    }

    public void OnTriggerEnter(Collider other)
    {
        if(other.gameObject.tag == "MonBateau")
        {
            onRange = true;
        }
    }
    public void OnTriggerExit(Collider other)
    {
        if (other.gameObject.tag == "MonBateau")
        {
            onRange = false;
        }
    }
}
