﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;
using System.Collections.Generic;

public class GestionTir : MonoBehaviour
{
    public GameObject Canon;
    public GameObject prefabFire;
    private GameObject fire;
    public int sens;
    public GameObject tourelle;
    public GameObject prefabMissile;
    public Scrollbar Reload;
    private GameObject missile;
    private bool loadComplete;
    private float angleCanon;
    private float angleTourelle;
    private bool isUsingCanon;
    private bool isUsingTourelle;
    private float force = 0.0f;

    public AudioSource bigGunSound; 


    // Use this for initialization
    void Start ()
    {
        loadComplete = true;
        bigGunSound.enabled = false;
    }
	
	// Update is called once per frame
	void Update ()
    {
        if(Input.GetKey(KeyCode.Z))
        {
            isUsingCanon = true;
            angleCanon += 0.2f;
        }

        if (Input.GetKey(KeyCode.S))
        {
            isUsingCanon = true;
            angleCanon -= 0.2f;
        }
        if (Input.GetKey(KeyCode.Q))
        {
            isUsingTourelle = true;
            angleTourelle-=  0.5f;
        }

        if (Input.GetKey(KeyCode.D))
        {
            isUsingTourelle = true;
            angleTourelle+=  0.5f;
        }
        if (isUsingCanon)
        {
            angleCanon = Mathf.Clamp(angleCanon, 0, 20);
            Canon.transform.localEulerAngles = new Vector3(-angleCanon, 0, 0);
        }
        if (isUsingTourelle)
        {
            angleTourelle = Mathf.Clamp(angleTourelle, 140, 400);
            tourelle.transform.localEulerAngles = new Vector3(0, sens * -angleTourelle, 0);
        }
        if (Input.GetKeyUp(KeyCode.Z) || Input.GetKeyUp(KeyCode.S))
        {
            isUsingCanon = false;
        }
        if (Input.GetKeyUp(KeyCode.Q) || Input.GetKeyUp(KeyCode.D))
        {
            isUsingTourelle = false;
        }
        if (loadComplete)
        {
            if (Input.GetKeyDown(KeyCode.Space))
            {
                    missile = Instantiate(prefabMissile, transform.position, Quaternion.identity) as GameObject;
                    Rigidbody rb = missile.GetComponent<Rigidbody>();
                    force = Random.Range(900, 1000);
                    rb.AddForce(Canon.transform.forward * force, ForceMode.Impulse);
                    Reload.size = 0.0f;
                    loadComplete = false;

                    fire = Instantiate(prefabFire, transform.position, transform.rotation) as GameObject;
                    bigGunSound.enabled = true;
                    bigGunSound.Play();
            }
        }
        if(!loadComplete)
        {
            Reload.size += 0.008f * Time.deltaTime;

            if(Reload.size>=1.0f)
            {
                Destroy(fire);
                loadComplete = true;
            }
        }
    }
}

