﻿using UnityEngine;
using System.Collections.Generic;

public class CollisionMissile : MonoBehaviour
{
    public GameObject prefabExplosionsFeu;
    public GameObject prefabExplosionsEau;
    public bool perdu = false;
       

    private float timer = 3.0f ;

    private List<GameObject> explosions = null;

    void Start()
    {
       
    }

    void OnTriggerEnter(Collider other)
    {
        if (other.gameObject.tag == "Ennemi")
        {
            if (explosions == null)
            {
                explosions = new List<GameObject>();
            }
            explosions.Add(Instantiate(prefabExplosionsFeu, transform.position, Quaternion.identity) as GameObject);
            Invoke("DestroyExplosion", timer);
            gameObject.GetComponent<MeshRenderer>().enabled = false;
            gameObject.GetComponent<Collider>().enabled = false;
        }
        if (other.gameObject.tag == "MonBateau")
        {
            if (explosions == null)
            {
                explosions = new List<GameObject>();
            }
            explosions.Add(Instantiate(prefabExplosionsFeu, transform.position, Quaternion.identity) as GameObject);
            GameObject.Find("Aura").GetComponent<DegatsMonBateau>().Vie.size -= 0.01f;
            GameObject.Find("Aura").GetComponent<DegatsMonBateau>().PourcentageDeVie -= 1;
            GameObject.Find("Aura").GetComponent<DegatsMonBateau>().VieTexte.text = "" + GameObject.Find("Aura").GetComponent<DegatsMonBateau>().PourcentageDeVie + "%";
            gameObject.GetComponent<MeshRenderer>().enabled = false;
            gameObject.GetComponent<Collider>().enabled = false;
            Invoke("DestroyExplosion", timer);
        }

        if (other.gameObject.tag == "Ocean")
        {
            if (explosions == null)
            {
                explosions = new List<GameObject>();
            }
            explosions.Add(Instantiate(prefabExplosionsEau, transform.position, Quaternion.identity) as GameObject);
            Invoke("DestroyExplosion", timer);
            gameObject.GetComponent<MeshRenderer>().enabled = false;
            gameObject.GetComponent<Collider>().enabled = false;
        }
        if (other.gameObject.tag == "Mur")
        {
            Destroy(gameObject);
            Debug.Log("toucheMur");
        }
    }
    public void DestroyExplosion()
    {
        foreach (GameObject explosion in explosions)
        {
            Destroy(explosion);
        }
        Destroy(gameObject);
    }
}
