﻿using UnityEngine;
using System.Collections;
using System;

public class Unlock_functionalities : MonoBehaviour
{
    public enum UNLOCK_ITEMS
    {
        VOITURE = 0,
        MAIN,
        CRANE,

        COUNT
    }

    Renderer rend;

    public UNLOCK_ITEMS type;

    void Start()
    {   
        rend = GetComponent<Renderer>();
        rend.material.shader = Shader.Find("Outlined/Silhouetted Bumped Diffuse");
    }

    // Update is called once per frame
    void FixedUpdate()
    {
       transform.Rotate(0, 20.0f * Time.deltaTime, 0);
    }

    void OnMouseEnter()
    {
        rend.material.SetFloat("_Outline", 0.002f);
    }
    void OnMouseOver()
    {
        rend.material.SetFloat("_Outline", 0.002f);

        if (Input.GetKey(KeyCode.Mouse0))
        {
            ScoreShower.Instance.HandInfos.SetActive(false);
            SoundManager.PlaySound("Unlock");

            if ((int)type == 0)
                ActiverDeplacement();

            if ((int)type == 1)
                ActiverAttraper();

            if ((int)type == 2)
                ActiverMort();
        }
    }
    void OnMouseExit()
    {
        rend.material.SetFloat("_Outline", 0.0f);
    }

    void ActiverDeplacement()
    {
        GetComponent<QuestionManager>().ActiveQuestion();
    }

    void ActiverAttraper()
    {
        Robot_Lvl1.instanceRobot.SetBoolAttraper(true);
        GetComponent<QuestionManager>().ActiveQuestion();
    }

    void ActiverMort()
    {
        Robot_Lvl1.instanceRobot.SetBoolDeath(true);
        GetComponent<QuestionManager>().ActiveQuestion();
        transform.parent.GetComponentInChildren<CraneDoor>().StartAnimation();

    }

    void Cinematique()
    {
    }

}
