﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class Teleportation : MonoBehaviour {

    public enum PORTAILS
    {
        PORTAIL1 = 0,
        PORTAIL2,

        COUNT
    }

    public PORTAILS portailType;
    Teleportation linkedPortail;

    // Use this for initialization
    void Start ()
    {
        if (Phase1_State.instance != null)
        {
            Transform levelData = LevelManager.Instance.levelData;

            for (int i = 0; i < levelData.childCount; i++)
            {
                Transform child = levelData.GetChild(i);

                Teleportation teleportation = child.GetComponent<Teleportation>();

                if (teleportation != null && teleportation != this)
                {
                    if (teleportation.portailType == portailType)
                    {
                        // On link les deux
                        linkedPortail = teleportation;
                        teleportation.linkedPortail = this;
                    }
                }
                
            }
        }
    }
	
	// Update is called once per frame
	void FixedUpdate () {
	
	}

    void OnTriggerEnter(Collider other)
    {
        Robot_Lvl1 robot = other.GetComponent<Robot_Lvl1>();

        if (robot != null)
        {
            if (Time.time - robot.previousTeleport > 1.0f)
            {
                SoundManager.PlaySound("Portail");
                robot.previousTeleport = Time.time;
                other.transform.position = new Vector3 (linkedPortail.transform.position.x, other.transform.position.y, linkedPortail.transform.position.z);
            }
        }
    }
}
