﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;
using System;
using System.IO;

public class ScoreShower : MonoBehaviour
{

    private static ScoreShower s_Instance;
    public static ScoreShower Instance
    {
        set
        {
            s_Instance = value;
        }
        get
        {
            if (s_Instance == null)
            {
                s_Instance = FindObjectOfType<ScoreShower>();
            }
            return s_Instance;
        }
    }

    public float time = 0;
    public int humanPoints = 0;
    public int machinePoints = 0;
    public int death = 0;
    public int niveau = 1;

    public GameObject[] Jauge_Humain;
    public GameObject[] Jauge_Robot;

    public GameObject HandInfos;

    public void AddPoints(int humainP, int machineP)
    {
        humanPoints += humainP;
        machinePoints += machineP;
        Debug.Log(humanPoints + " " + machinePoints);
    }

    public void AddDeath()
    {
        death++;
    }
    void Update()
    {
        if(Menu_StateMachine.instanceMenu.GetState() == STATE.NEW_GAME)
        {
            UpdateTime();
            transform.GetChild(0).gameObject.SetActive(true);
        }
        else
        { 
            transform.GetChild(0).gameObject.SetActive(false);
        }

        //transform.GetChild(0).GetChild(1).GetComponent<Text>().text =
        //    humanPoints.ToString() + "\n" +
        //    machinePoints.ToString() + "\n" +
        //    death.ToString() + "\n" +
        //    ((int)time).ToString() + "\n";
        transform.GetChild(0).GetChild(2).GetChild(0).GetComponent<Text>().text = ((int)time).ToString();
        transform.GetChild(0).GetChild(3).GetChild(2).GetChild(0).GetComponent<Text>().text = death.ToString();

        switch (humanPoints)
        {
            case 0:
                Jauge_Humain[0].SetActive(false);
                Jauge_Humain[1].SetActive(false);
                Jauge_Humain[2].SetActive(false);
                Jauge_Humain[3].SetActive(false);
                Jauge_Humain[4].SetActive(false);
                Jauge_Humain[5].SetActive(false);
                break;
            case 5:
                Jauge_Humain[0].SetActive(true);
                Jauge_Humain[1].SetActive(false);
                Jauge_Humain[2].SetActive(false);
                Jauge_Humain[3].SetActive(false);
                Jauge_Humain[4].SetActive(false);
                Jauge_Humain[5].SetActive(false);
                break;
            case 10:
                Jauge_Humain[0].SetActive(true);
                Jauge_Humain[1].SetActive(true);
                Jauge_Humain[2].SetActive(false);
                Jauge_Humain[3].SetActive(false);
                Jauge_Humain[4].SetActive(false);
                Jauge_Humain[5].SetActive(false);
                break;
            case 15:
                Jauge_Humain[0].SetActive(true);
                Jauge_Humain[1].SetActive(true);
                Jauge_Humain[2].SetActive(true);
                Jauge_Humain[3].SetActive(false);
                Jauge_Humain[4].SetActive(false);
                Jauge_Humain[5].SetActive(false);
                break;
            case 20:
                Jauge_Humain[0].SetActive(true);
                Jauge_Humain[1].SetActive(true);
                Jauge_Humain[2].SetActive(true);
                Jauge_Humain[3].SetActive(true);
                Jauge_Humain[4].SetActive(false);
                Jauge_Humain[5].SetActive(false);
                break;
            case 25:
                Jauge_Humain[0].SetActive(true);
                Jauge_Humain[1].SetActive(true);
                Jauge_Humain[2].SetActive(true);
                Jauge_Humain[3].SetActive(true);
                Jauge_Humain[4].SetActive(true);
                Jauge_Humain[5].SetActive(false);
                break;
            case 30:
                Jauge_Humain[0].SetActive(true);
                Jauge_Humain[1].SetActive(true);
                Jauge_Humain[2].SetActive(true);
                Jauge_Humain[3].SetActive(true);
                Jauge_Humain[4].SetActive(true);
                Jauge_Humain[5].SetActive(true);
                break;
               
        }
        switch (machinePoints)
        {
            case 0:
                Jauge_Robot[0].SetActive(false);
                Jauge_Robot[1].SetActive(false);
                Jauge_Robot[2].SetActive(false);
                Jauge_Robot[3].SetActive(false);
                Jauge_Robot[4].SetActive(false);
                Jauge_Robot[5].SetActive(false);
                break;
            case 5:
                Jauge_Robot[0].SetActive(true);
                Jauge_Robot[1].SetActive(false);
                Jauge_Robot[2].SetActive(false);
                Jauge_Robot[3].SetActive(false);
                Jauge_Robot[4].SetActive(false);
                Jauge_Robot[5].SetActive(false);
                break;
            case 10:
                Jauge_Robot[0].SetActive(true);
                Jauge_Robot[1].SetActive(true);
                Jauge_Robot[2].SetActive(false);
                Jauge_Robot[3].SetActive(false);
                Jauge_Robot[4].SetActive(false);
                Jauge_Robot[5].SetActive(false);
                break;
            case 15:
                Jauge_Robot[0].SetActive(true);
                Jauge_Robot[1].SetActive(true);
                Jauge_Robot[2].SetActive(true);
                Jauge_Robot[3].SetActive(false);
                Jauge_Robot[4].SetActive(false);
                Jauge_Robot[5].SetActive(false);
                break;
            case 20:
                Jauge_Robot[0].SetActive(true);
                Jauge_Robot[1].SetActive(true);
                Jauge_Robot[2].SetActive(true);
                Jauge_Robot[3].SetActive(true);
                Jauge_Robot[4].SetActive(false);
                Jauge_Robot[5].SetActive(false);
                break;
            case 25:
                Jauge_Robot[0].SetActive(true);
                Jauge_Robot[1].SetActive(true);
                Jauge_Robot[2].SetActive(true);
                Jauge_Robot[3].SetActive(true);
                Jauge_Robot[4].SetActive(true);
                Jauge_Robot[5].SetActive(false);
                break;
            case 30:
                Jauge_Robot[0].SetActive(true);
                Jauge_Robot[1].SetActive(true);
                Jauge_Robot[2].SetActive(true);
                Jauge_Robot[3].SetActive(true);
                Jauge_Robot[4].SetActive(true);
                Jauge_Robot[5].SetActive(true);
                break;

        }
    }

    void UpdateTime()
    {
        time += Time.deltaTime;
    }

    public void Reset()
    {
        time = 0;
        humanPoints = 0;
        machinePoints = 0;
        death = 0;
        niveau = 1;
    }
    
}
