﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class ScoreSaver : MonoBehaviour
{
    static ScoreSaver s_Instance;
    public static ScoreSaver Instance
    {
        set { s_Instance = value; }
        get
        {
            if(s_Instance == null)
                s_Instance = FindObjectOfType<ScoreSaver>();
            return s_Instance;
        }
    }

    void Awake()
    {
        s_Instance = this;
        gameObject.SetActive(false);
    }

    public Text[] m_Phase1ScoreTexts;
    public Text[] m_Phase2ScoreTexts;
    public Text[] m_Phase3ScoreTexts;
    
    public void UpdateScore(int phaseID, int Hp, int Mp, int T, int D)
    {
        switch(phaseID)
        {
            case 0:
                m_Phase1ScoreTexts[0].text = Hp.ToString();
                m_Phase1ScoreTexts[1].text = Mp.ToString();
                m_Phase1ScoreTexts[2].text = T.ToString();
                m_Phase1ScoreTexts[3].text = D.ToString();
                break;
            case 1:
                m_Phase2ScoreTexts[0].text = Hp.ToString();
                m_Phase2ScoreTexts[1].text = Mp.ToString();
                m_Phase2ScoreTexts[2].text = T.ToString();
                m_Phase2ScoreTexts[3].text = D.ToString();
                break;
            case 2:
                m_Phase3ScoreTexts[0].text = Hp.ToString();
                m_Phase3ScoreTexts[1].text = Mp.ToString();
                m_Phase3ScoreTexts[2].text = T.ToString();
                m_Phase3ScoreTexts[3].text = D.ToString();
                break;
        }
    }
}
