﻿using UnityEngine;
using System.Collections;

public class Robot_Lvl2 : MonoBehaviour
{

    public static Robot_Lvl2 instance;
    public bool deplacementFunction = true;

    bool isRight = true;
    Animator animator;

    // Use this for initialization
    void Start()
    {

        if (instance != null)
        {
            Debug.Log("Singleton Robot2 twice");
            return;
        }
        instance = this;
        animator = transform.GetComponent<Animator>();
    }

    void OnDestroy()
    {
        if (instance == this)
            instance = null;
    }

    // Update is called once per frame
    void FixedUpdate()
    {
        if (deplacementFunction)
        {
            if (Input.GetKey(KeyCode.Mouse0))
            {
                Vector2 mousePosition = new Vector2(Input.mousePosition.x, Input.mousePosition.y);
                if (mousePosition.x < Screen.width / 2)
                {
                    transform.rotation = Quaternion.Euler(0, 90f, 0);
                    isRight = false;
                    transform.position = Vector3.Lerp(transform.position, transform.position + transform.forward/2, Time.deltaTime * 6.0f);
                }
                else if (mousePosition.x >= Screen.width / 2)
                {
                    transform.rotation = Quaternion.Euler(0, -90f, 0);
                    isRight = true;
                    transform.position = Vector3.Lerp(transform.position, transform.position + transform.forward/2, Time.deltaTime * 6.0f);
                }

            }

            if(Input.GetKeyDown(KeyCode.Space))
            {
                if (isRight)
                    transform.GetComponent<Rigidbody>().velocity = new Vector3(-1.0f, 2.0f, 0.0f);

                else
                    transform.GetComponent<Rigidbody>().velocity = new Vector3(1.0f, 2.0f, 0.0f);
            }
        }
        ClampRotation();
    }

    void ClampRotation()
    {
        Vector3 eulerRotation = transform.rotation.eulerAngles;
        eulerRotation.x = eulerRotation.z = 0f;
        transform.rotation = Quaternion.Euler(eulerRotation);
    }
}