﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;
using System.Collections.Generic;

public class Robot_Lvl1 : MonoBehaviour {

    public float speed = 10.0f;
    public static bool doorOpen = false;
    Fruit carryingFruit;
    UnlockDoor unlockDoor;
    MineBehaviour mine;

    public Object explodePrefab;
    public Object boomPrefab;

   // public Texture2D m_ShadowMapLvl2;

    public static Robot_Lvl1 instanceRobot;
    public bool deplacementFunction = false;
    private bool AttraperFunction = false;
    private bool DeathFunction = false;
    public LayerMask Sol;
    public Transform Target;
    public Material Light_robot;

    AudioSource audio;

    private enum direction
    {
        Forward,
        Left,
        Backward,
        Right
    }

    public float previousTeleport;
    private direction m_MyDirection; 

    // Use this for initialization
    void Start ()
    {
        transform.SetParent(LevelManager.Instance.levelData);
        Target.SetParent(LevelManager.Instance.levelData);
        Target.position = Vector3.zero;

        previousTeleport = 0.0f;
        if (instanceRobot != null)
        {
            Debug.Log("Singleton Robot twice");
            return;
        }
        instanceRobot = this;
        audio = GetComponent<AudioSource>();
        m_MyDirection = direction.Right;
    }
    
    void OnDestroy()
    {
        if(instanceRobot == this)
            instanceRobot = null;
    }

    void Update()
    {
        if (carryingFruit != null)
        {
            carryingFruit.transform.position = transform.position + Vector3.up * 1.0f;
        }

       /* if (Input.GetKeyDown(KeyCode.K))
        {
            Death(null);
        }*/

    }

   public void LeaveFruit(UnlockDoor unlockDoor)
    {
        if (carryingFruit != null && AttraperFunction)
        {
            carryingFruit.transform.position = unlockDoor.transform.position+ Vector3.up*0.5f;
            carryingFruit.GetComponent<Collider>().enabled = false;
            carryingFruit = null;
            unlockDoor.transform.GetChild(0).gameObject.SetActive(false);
            doorOpen = true;
            SoundManager.PlaySound("Porte");
        }
    }

   public void OpenDoor(DoorBehaviour door)
   {

   }

    void FixedUpdate()
    {
        if (deplacementFunction)
        {
            if (!audio)
                audio = GetComponent<AudioSource>();
            if (Input.GetKey(KeyCode.Mouse0))
            {
                Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);
                RaycastHit hit;
                if (Physics.Raycast(ray, out hit, 100.0f, Sol))
                {
                    Target.position = new Vector3(hit.point.x, transform.position.y, hit.point.z);

                    Vector3 targetPosition = Target.position;
                    targetPosition.y = transform.position.y;
                    Target.position = targetPosition;

                    Quaternion actualDirection = transform.rotation;
                    transform.LookAt(Target);
                    Quaternion desiredRotation = transform.rotation;

                    transform.position = Vector3.Lerp(transform.position, transform.position + transform.forward, Time.deltaTime * 6.0f);
                    transform.rotation = Quaternion.Lerp(actualDirection, desiredRotation, Time.deltaTime * 10f);

                    if (!audio.isPlaying)
                        audio.Play();

                }

            }

            else
                audio.Stop();

        }
        
        GetComponent<Rigidbody>().velocity = Vector3.zero;

    }

    void Deplacement()
    {
        Quaternion desiredRotation = Quaternion.identity;
        switch (m_MyDirection)
        {
            case direction.Forward:
                desiredRotation = Quaternion.identity;
                break;
            case direction.Left:
                desiredRotation = Quaternion.Euler(0, 270f, 0);
                break;
            case direction.Backward:
                desiredRotation = Quaternion.Euler(0, 180f, 0);
                break;
            case direction.Right:
                desiredRotation = Quaternion.Euler(0, 90f, 0);
                break;
            default:
                break;
        }
        transform.rotation = Quaternion.Lerp(transform.rotation, desiredRotation, Time.deltaTime * 10f);
    }
   

    public void Action(Fruit fruit)
    {
        if (carryingFruit == null && AttraperFunction)
        {
            carryingFruit = fruit;
            SoundManager.PlaySound("Fruit");
        }
    }

    public void Death(MineBehaviour ennemi)
    {
        if (DeathFunction)
        {
            SoundManager.PlaySound("Explosion");
            ScoreShower.Instance.AddDeath();

            if (LevelManager.Instance.m_CurrentLevelID == 0)
            {
                ScoreShower.Instance.humanPoints = 0;
                ScoreShower.Instance.machinePoints = 0;
            }
           // ScoreShower.Instance.time = 0.0f;
            doorOpen = false;
            Instantiate(explodePrefab, transform.position, Quaternion.Euler(0,-45,0));
            LevelDataManager.levelinstance.boomPrefabs.Add(Instantiate(boomPrefab, transform.position + new Vector3(0, -transform.localScale.y / 1.7f, 0), Quaternion.Euler(90, 0, 0)));
            ennemi.gameObject.SetActive(false);

            StartCoroutine(C_ReloadGame(2f));
               
        }
    }
    public void SetBoolDeplacement(bool setdeplacement)
    {
        deplacementFunction = setdeplacement;
    }
    public void SetBoolAttraper(bool setAttraper)
    {
        AttraperFunction = setAttraper;
    }
    public void SetBoolDeath (bool setDeath)
    {
        DeathFunction = setDeath;
    }

    public void ActiveAllFunctionnalities(bool active = true)
    {
        SetBoolDeplacement(active);
        SetBoolAttraper(active);
        SetBoolDeath(active);
    }

    IEnumerator C_ReloadGame(float delay)
    {
        transform.GetComponent<MeshRenderer>().enabled = false;
        ActiveAllFunctionnalities(false);
        yield return new WaitForSeconds(delay);
        SoundManager.PlaySound("Voice06");
        instanceRobot = null;
        LevelManager.Instance.CreateLevel(LevelManager.Instance.m_CurrentLevelID);


    }

    public void SetMaterialColor(Color color)
    {
        Light_robot.color = color;
    }

}
