﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class QuestionShower : MonoBehaviour
{
    public static QuestionShower s_Instance;

    public Text m_AskText;
    public Text[] m_AnswerTab;

    private QuestionManager m_CurrentQuestion;

    public bool m_Active;
	// Use this for initialization
	void Start ()
    {
        s_Instance = this;
        ActiveShower(false);
    }
    void ActiveShower(bool active)
    {
        transform.GetChild(0).gameObject.SetActive(active);
        m_Active = active;
    }

    public void ActiveQuestion(QuestionManager newQuestion)
    {
        ActiveShower(true);
        m_AskText.text = newQuestion.m_Question;
        for (int reponseID = 0; reponseID < newQuestion.m_ReponseAnswer.Length; reponseID++)        
        {
            m_AnswerTab[reponseID].text = newQuestion.m_ReponseAnswer[reponseID].text;
        }

        m_CurrentQuestion = newQuestion;
    }

    public void Answer(int reponseID)
    {
        ScoreShower.Instance.AddPoints(m_CurrentQuestion.m_ReponseAnswer[reponseID].humanPoints, m_CurrentQuestion.m_ReponseAnswer[reponseID].mecanicPoints);

        ActiveShower(false);
       
        m_CurrentQuestion.gameObject.SetActive(false);
       // Destroy(m_CurrentQuestion.gameObject);

        Robot_Lvl1.instanceRobot.SetBoolDeplacement(true);

        if((int)m_CurrentQuestion.GetComponent<Unlock_functionalities>().type == 0)
        {
            SoundManager.PlaySound("Voice03");
        }

        if ((int)m_CurrentQuestion.GetComponent<Unlock_functionalities>().type == 1)
        {
            SoundManager.PlaySound("Voice04");
        }

        if ((int)m_CurrentQuestion.GetComponent<Unlock_functionalities>().type == 2)
        {
            SoundManager.PlaySound("Voice05");
        }
    }
}
