﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using UnityEngine.UI;

public class Phase1_State : State {

    public GameObject couleurQuestion;
    [HideInInspector]public bool clickCouleur = false;
    public Image black;

    public static Phase1_State instance;

    void Awake()
    {
        instance = this;
    }

    float timer = 0.0f;
    Unlock_functionalities[] unlockItems;


    //------------------------------------------INIT---------------------------------------------------
    override public void Init()
    {
        
        //On précise par le "true" que l'on crée une map de tutorial
        LevelManager.Instance.CreateLevel(0);
        clickCouleur = false;
        timer = Time.time;
        couleurQuestion.SetActive(false);
        //on désactive les objets à cliquer pour ne pas pouvoir les activer en même temps que la première question
        unlockItems = FindObjectsOfType<Unlock_functionalities>();
        foreach(Unlock_functionalities items in unlockItems)
        {
            items.gameObject.SetActive(false);
        }
        ScoreShower.Instance.HandInfos.SetActive(false);
        SoundManager.PlaySound("Voice01");
    }

    void Update()
    {
        
        black.CrossFadeAlpha(0, 4.5f, false);

        if (Time.time - timer > 2.0f && couleurQuestion != null && !clickCouleur)
        {
            couleurQuestion.SetActive(true);
        }
        else couleurQuestion.SetActive(false);

        if(black.color.a == 0.0f)
        {
            black.gameObject.SetActive(false);
        }
    }

    public void ActiveUnlockingObjects()
    {
        foreach (Unlock_functionalities items in unlockItems)
        {
            if (items != null)
            {
                items.gameObject.SetActive(true);
            }
        }
    }

    public override void Exit()
    {
        LevelManager.Instance.levelData.gameObject.SetActive(false);
    }
}
