﻿using UnityEngine;
using System.Collections;

public enum STATE
{
    MENU =0,
    NEW_GAME,
    PHASE2,
    PHASE3,
    SCORE,
    CREDITS,
    QUIT,

    COUNT
}
public class Menu_StateMachine : MonoBehaviour {

    public static Menu_StateMachine instanceMenu;
    public STATE state;

    public bool[] availablePhases;
    public UnityEngine.UI.Button[] availablePhasesButtons;
    
    public State[] stateGameObjectList;

    void Start () {

        if (instanceMenu != null)
        {
            Debug.Log("Singleton twice");
            return;
        }
        instanceMenu = this;

        SetState(STATE.MENU);

        ActiverPhase(0);

    }



    public void SetState(STATE newState)
    {
        //on désactive l'ancien
        stateGameObjectList[(int)state].Exit();
        stateGameObjectList[(int)state].gameObject.SetActive(false);

       // Debug.Log("=============== " + newState + "==============");

        //On active le nouveau
        stateGameObjectList[(int)newState].gameObject.SetActive(true);
        stateGameObjectList[(int)newState].Init();

        state = newState;

    }
    public STATE GetState()
    {
        return state;
    }

    public void ActiverPhase(int phaseID)
    {
        availablePhases[phaseID] = true;
        availablePhasesButtons[phaseID].enabled = true;
    }

}
