﻿using UnityEngine;
using System.Collections;

public class LevelEnd : MonoBehaviour
{
    public bool nextPhase = false;

    void Update()
    {
        if (nextPhase == true)
        {
            Menu_StateMachine.instanceMenu.SetState(STATE.MENU);
            Menu_StateMachine.instanceMenu.ActiverPhase(LevelManager.Instance.m_PhaseID + 1);
            ScoreSaver.Instance.UpdateScore(LevelManager.Instance.m_PhaseID,
                ScoreShower.Instance.humanPoints,
                ScoreShower.Instance.machinePoints,
                (int)ScoreShower.Instance.time,
                ScoreShower.Instance.death);
        }
    }

    void OnTriggerEnter(Collider other)
    {
        if(other.CompareTag("Player"))
        {
            Robot_Lvl1.doorOpen = false;

            if (LevelManager.Instance.m_CurrentLevelID < 2)
            {
                LevelManager.Instance.CreateLevel(LevelManager.Instance.m_CurrentLevelID + 1);
                SoundManager.PlaySound("Voice07");
            }
            else
            {
                Menu_StateMachine.instanceMenu.SetState(STATE.MENU);
                Menu_StateMachine.instanceMenu.ActiverPhase(LevelManager.Instance.m_PhaseID + 1);
                ScoreSaver.Instance.UpdateScore(LevelManager.Instance.m_PhaseID,
                    ScoreShower.Instance.humanPoints,
                    ScoreShower.Instance.machinePoints,
                    (int)ScoreShower.Instance.time,
                    ScoreShower.Instance.death);
            }
        }
    }
}
