﻿using UnityEngine;
using System.Collections;

public class CraneDoor : MonoBehaviour
{

    public void StartAnimation()
    {
        StartCoroutine(C_DoorOpenAnimation(1f));
    }

    public IEnumerator C_DoorOpenAnimation(float duration)
    {
        Vector3 startPosition = transform.position;
        for (float timer = 0; timer < duration; timer+=Time.deltaTime)
        {
            transform.position = Vector3.Slerp(startPosition, startPosition + Vector3.up * 2f, timer / duration);
            yield return 0;
        }
        transform.position = startPosition + Vector3.up * 2f;
    }
}
