﻿using UnityEngine;
using System.Collections;

public class Behavior : MonoBehaviour
{
    public float speed = 1f;
    // Use this for initialization
    void Start()
    {

    }

    // Update is called once per frame
    void Update()
    {
        if(CheckForGround())
        {
            GetComponent<Animator>().SetBool("airSpace", false);
            if (Input.GetKey(KeyCode.RightArrow))
            {
                GetComponent<Rigidbody>().velocity = transform.forward * Time.deltaTime * speed;
                GetComponent<Animator>().SetBool("moving", true);
            }
            else
            {
                GetComponent<Rigidbody>().velocity = Vector3.zero;
                GetComponent<Animator>().SetBool("moving", false);
            }
            if (Input.GetKeyDown(KeyCode.Space))
            {
                GetComponent<Rigidbody>().AddForce(Vector3.up * speed * Time.deltaTime * 100f);
                GetComponent<Animator>().SetBool("jump", true);
            }
            else
            {
                GetComponent<Animator>().SetBool("jump", false);
            }
        }
        else
        {
            GetComponent<Animator>().SetBool("airSpace", true);
        }
    }

    bool CheckForGround()
    {
        Debug.DrawLine(transform.position, transform.position - Vector3.up * 0.25f);
        return Physics.Raycast(transform.position, -transform.up, 0.25f);
    }
}
