﻿using UnityEngine;
using System.Collections;

public class Menu : MonoBehaviour {
	
	// Machine a états
	public string MenuState = "MenuPrincipal";
	
	// GUIStyle
	public GUIStyle MenuStyle ;
	
	// Records de chaque niveau
	private int recordLevel1 = 0;
	private int recordLevel2 = 0;
	
	// Textures menu
	public Texture2D logo ;
	public Texture2D HowTo1 ;
	public Texture2D HowTo2 ;


	void Start ()
	{
		// Chargement des records de chaque iveau
		recordLevel1 = PlayerPrefs.GetInt("RecordLevel1");
		recordLevel2 = PlayerPrefs.GetInt("RecordLevel2");
		
		// Lancement du meu principal
		MenuState = "MenuPrincipal";
	}
	

	void Update ()
	{
		// Machine a états
		switch(MenuState)
		{
			case "MenuPrincipal" : UpdateMenuPrincipal(); break;
			case "MenuNiveau" : UpdateMenuNiveau(); break;
			case "MenuTuto" : UpdateMenuTuto(); break;
		}
	
	}
	
	void OnGUI()
	{
		// Machine a états
		switch(MenuState)
		{
			case "MenuPrincipal" : OnGUIMenuPrincipal(); break;
			case "MenuNiveau" : OnGUIMenuNiveau(); break;
			case "MenuTuto" : OnGUIMenuTuto(); break;
		}
	}
	
	// ----- MENU PRINCIPAL -----
	void UpdateMenuPrincipal()
	{
		
	}
	void OnGUIMenuPrincipal()
	{
		GUI.DrawTexture(new Rect(Screen.width/2-400,50,480,480),logo);
		
		if(GUI.Button(new Rect(Screen.width/2+50,250,240,80),"Play",MenuStyle))
		{
			MenuState="MenuNiveau";
		}
		if(GUI.Button(new Rect(Screen.width/2+50,350,240,80),"Quit",MenuStyle))
		{
			Application.Quit();
		}
	}
	
	
	// ----- MENU CHOIX NIVEAU -----
	void UpdateMenuNiveau()
	{
		
	}
	void OnGUIMenuNiveau()
	{
		GUI.DrawTexture(new Rect(Screen.width/2-128,10,256,256),logo);
		
		if(GUI.Button(new Rect(Screen.width/2-300,300,240,80),"Level 1",MenuStyle))
		{
			MenuState = "MenuTuto";
		}
		GUI.Label(new Rect(Screen.width/2+10,300,400,80), "Record : " + recordLevel1, MenuStyle);
		
		if(GUI.Button(new Rect(Screen.width/2-300,400,240,80),"Level 2",MenuStyle))
		{
			Application.LoadLevel("S2");
		}
		GUI.Label(new Rect(Screen.width/2+10,400,400,80), "Record : " + recordLevel2, MenuStyle);
		
		if(GUI.Button(new Rect(Screen.width/2-120,500,240,80),"Back",MenuStyle))
		{
			MenuState = "MenuPrincipal";
		}
	}
	
	
	// ----- MENU TUTO -----
	void UpdateMenuTuto()
	{
		
	}
	void OnGUIMenuTuto()
	{
		if(GUI.Button(new Rect(Screen.width-410,Screen.height-90,400,80),"Start Level 1",MenuStyle))
		{
			Application.LoadLevel("S1");
		}
		if(GUI.Button(new Rect(10,Screen.height-90,200,80),"Back",MenuStyle))
		{
			MenuState="MenuNiveau";
		}
		
		GUI.Label(new Rect(Screen.width/2-300,10,600,80), "How to play ?", MenuStyle);
		GUI.DrawTexture(new Rect(Screen.width/2-460,100,450,450),HowTo1);
		GUI.DrawTexture(new Rect(Screen.width/2+10,100,450,450),HowTo2);
	}
}
