﻿using UnityEngine;
using System.Collections;

public class Ball : MonoBehaviour {
	
	// Machine a etats
	public string GameState = "GameStart";
	
	// GUIStyle
	public GUIStyle GameStyle ;
	
	// Gameobjects
	public GameObject CamEMPTY;
	public GameObject empty;
	public GameObject playerCamera;
	public GameObject ball;
	public GameObject currentLevelGameObject;
	public GameObject StartZone;
	
	// Donées
	public static int score = 0;
	private int record = 0;
	private int currentLevel = 1;
	public static bool endLevel = false;
	public static bool lostLevel = false;
	private float ballForce = 8.0f;
	private float space=0.0f;
	
	// Timer
	private float timer = 180.0f;
	private int intTimer = 180;

	// Vecteur de la camera
	private Vector3 camForward;
	private Vector3 camLeft;
	
	// Music
	public AudioClip[] Tracks;
	//public AudioClip Track02;

	
	void Start ()
	{
		// Récupération du numéro du niveau actuel
		switch(currentLevelGameObject.tag)
		{
			case "Level1" : currentLevel=1 ; break;
			case "Level2" : currentLevel=2 ; break;
		}

		// Chargement du meilleur score du niveau actuel
		record = PlayerPrefs.GetInt("RecordLevel"+currentLevel);
		
		// Lancement de l'animation de caméra
		if (!playerCamera.animation.IsPlaying("camera"))
		{
			playerCamera.animation.Play("camera");
		}
		
		// Passage à l'étape de lancement du jeu
		GameState = "GameStart";
	}
	
	void Update ()
	{
		// Machine à états
		switch(GameState)
		{
			case "GameStart" : UpdateGameStart(); break;
			case "GamePlay" : UpdateGamePlay(); break;
			case "GamePause" : UpdateGamePause(); break;
			case "GameWin" : UpdateGameWin(); break;
			case "GameLost" : UpdateGameLost(); break;
		}
	}
	
	void OnGUI()
	{
		// Machine à états
		switch(GameState)
		{
			case "GameStart" : OnGUIGameStart(); break;
			case "GamePlay" : OnGUIGamePlay(); break;
			case "GamePause" : OnGUIGamePause(); break;
			case "GameWin" : OnGUIGameWin(); break;
			case "GameLost" : OnGUIGameLost(); break;
		}
	}
	
	
	// ----- LANCEMENT DU NIVEAU -----
	void UpdateGameStart()
	{
		// Initialisation de certains éléments
		endLevel = false;
		lostLevel = false;
		score=0;
		Time.timeScale = 1;
		ball.transform.rotation = new Quaternion(0,0,0,0);
		ball.transform.position = StartZone.transform.position ;
		timer=180.0f;
		
		// Passage à l'étape de déroulement du jeu
		GameState = "GamePlay";	
	}
	void OnGUIGameStart()
	{
		
	}
	
	
	// ----- LE JEU SE DEROULE -----
	void UpdateGamePlay()
	{
		
		// Audio
		if (! audio.isPlaying)
		{
			audio.clip = Tracks[0];
			audio.Play();
		}
		
		// Timer
		timer-=Time.deltaTime;
		intTimer=Mathf.FloorToInt(timer);
		
		// Orientation de la camera
		camForward = playerCamera.transform.forward;
    	camForward.y = 0.0f;
    	Vector3.Normalize(camForward);
		camLeft = camForward;
		camLeft = Quaternion.AngleAxis(-90, Vector3.up) * camLeft;
		
		// Mouvements de la camera
		empty.transform.eulerAngles = new Vector3(0,0,0);
		CamEMPTY.transform.position=empty.transform.position;
		CamEMPTY.transform.Rotate(0, Input.GetAxis("Mouse X") * 6, 0);

		// Commandes de la balle
		if (Input.GetKey("z"))
		{
			ball.rigidbody.AddForce ( camForward * ballForce);
		}
		if (Input.GetKey("s"))
		{
			ball.rigidbody.AddForce ( -camForward * ballForce);
		}
		if (Input.GetKey("q"))
		{
			ball.rigidbody.AddForce (camLeft * ballForce);
		}
		if (Input.GetKey("d"))
		{
			ball.rigidbody.AddForce (-camLeft * ballForce);
		}
		if (Input.GetKeyDown("space") && Time.time > space )
		{
			space = Time.time + 1.0f;
			ball.rigidbody.AddForce (Vector3.up * 250);
		}
		
		// Lancement menu pause
		if (Input.GetKeyDown("escape"))
		{
			GameState = "GamePause";
		}
		
		// Fin de jeu si victoire
		if (endLevel==true)
		{
			if (score>record)
			{
				// Sauvegarde du nouveau record
				PlayerPrefs.SetInt("RecordLevel"+currentLevel,score);
			}
			GameState = "GameWin";
		}
		
		// Fin de jeu si temps écoulé
		if (intTimer<=0)
		{
			GameState = "GameLost";
		}
		
		// Fin de jeu si le joueur tombe dans la lave
		if (lostLevel==true)
		{
			GameState = "GameLost";
		}
	}
	void OnGUIGamePlay()
	{
		// Affichage d'informations
		GUI.Label(new Rect(10,10, 400, 60), "Score : " + score, GameStyle);
		GUI.Label(new Rect(Screen.width-310,10, 300, 60), "Time : " + intTimer, GameStyle);
	}
	
	
	// ----- MENU PAUSE -----
	void UpdateGamePause()
	{
		Time.timeScale = 0;
	}
	void OnGUIGamePause()
	{
		GUI.Label(new Rect(Screen.width/2-200,100, 400, 80), "Pause :", GameStyle);
		
		if(GUI.Button(new Rect(Screen.width/2-200,300,400,80),"Play",GameStyle))
		{
			Time.timeScale = 1;
			GameState = "GamePlay";
		}
		if(GUI.Button(new Rect(Screen.width/2-200,400,400,80),"Restart",GameStyle))
		{
			Application.LoadLevel(Application.loadedLevel);
			GameState = "GameStart";
		}
		if(GUI.Button(new Rect(Screen.width/2-200,500,400,80),"Quit level",GameStyle))
		{
			Application.LoadLevel("Menu");
		}
	}
	
	
	// ----- NIVEAU GAGNE -----
	void UpdateGameWin()
	{
		ball.rigidbody.Sleep();
	}
	void OnGUIGameWin()
	{
		GUI.Label(new Rect(Screen.width/2-450,20, 900, 250), "Congratulations !" +"\n" + "You have completed the Level " + currentLevel +"\n" +"\n" + " Your score : " + score , GameStyle);
		if (score>record)
			{
				GUI.Label(new Rect(Screen.width/2-450,280, 900, 80), "You beat the best time !!!",GameStyle);
			}
		
		if (currentLevel==1)
		{
			if(GUI.Button(new Rect(Screen.width/2-200,400,400,80),"Next level",GameStyle))
			{
				Application.LoadLevel("S2");
			}
		}
		if(GUI.Button(new Rect(Screen.width/2-200,500,400,80),"Quit level",GameStyle))
		{
			Application.LoadLevel("Menu");
		}
	}
	
	
	// ----- NIVEAU PERDU -----
	void UpdateGameLost()
	{
		
	}
	void OnGUIGameLost()
	{
		ball.rigidbody.Sleep();
		GUI.Label(new Rect(Screen.width/2-450,20, 900, 250), "Sorry, you lost" +"\n" + "Try again ! ", GameStyle);
		
		if(GUI.Button(new Rect(Screen.width/2-200,400,400,80),"Restart",GameStyle))
		{
			Application.LoadLevel(Application.loadedLevel);
			GameState = "GameStart";
		}
		
		if(GUI.Button(new Rect(Screen.width/2-200,500,400,80),"Quit level",GameStyle))
		{
			Application.LoadLevel("Menu");
		}
	}
}


