using UnityEngine;
using System.Collections;

public class Deplacer : MonoBehaviour {
	
	private float vitesseTranslation;
	private float vitesseRotation;
	
	public Font font;
	
	private bool afficherGUI;
	
	// Use this for initialization
	void Start () {
		vitesseTranslation = 1.0f;
		vitesseRotation = 50.0f;
		afficherGUI = true;
	}
	
	// Update is called once per frame
	void Update () {
        if (Input.GetKey(KeyCode.UpArrow) )
            transform.Translate(Vector3.forward * vitesseTranslation * Time.deltaTime);
        
        if (Input.GetKey(KeyCode.DownArrow))
            transform.Translate(Vector3.back * vitesseTranslation * Time.deltaTime);
		
		if (Input.GetKey(KeyCode.LeftArrow))
            transform.Rotate(Vector3.down * vitesseRotation * Time.deltaTime);
		
		if (Input.GetKey(KeyCode.RightArrow))
            transform.Rotate(Vector3.up * vitesseRotation * Time.deltaTime);
	}
	
	void OnCollisionEnter(Collision col)
	{
		if (!(col.collider.gameObject.name.Equals("Sol")))
		{
			Debug.Log("touche");
		}
	}
	
	void OnCollisionExit(Collision col)
	{
		Debug.Log("non touche");
	}
	
	void OnGUI()
	{
		if (afficherGUI)
		{
			GUI.skin.button.font = font;
			GUI.skin.button.normal.textColor = Color.white;
			GUI.skin.button.fontSize = (int)(Screen.height * 0.05f);
			GUI.skin.button.fontStyle = FontStyle.Bold;
			GUI.skin.button.alignment = TextAnchor.MiddleCenter;
			
			if (GUI.Button(new Rect(0, 0, Screen.width, Screen.height), "Pour vous d\u00E9placer, utilisez les fl\u00E8ches directionnelles\n" +
				"D\u00E9placez vous vers la lampe\nCliquez pour enlever l'aide"))
			{
				afficherGUI = false;
			}
		}
	}
}
