using UnityEngine;
using System.Collections;

public class CaseBehaviour : MonoBehaviour {
	
	private bool caseSelectionnee = false;
	
	public string typeCase;
	
	// Variables pour le mouvement
	private bool hasToMove;
	private bool moving;
	private float initialX;
	private float initialY;
	private float initialZ;
	private float toMoveX;
	private float toMoveY;
	private float toMoveZ;
	private float moveTime;
	private float startTime;
	
	// Use this for initialization
	void Start () {
		
	}
	
	// Update is called once per frame
	void Update ()
	{
		// Pour le mouvement
		if (moving)
		{
			float elapsedTime = Time.time - startTime;
			
			float newX = initialX + (Mathf.Sin ((-Mathf.PI/2.0f) + elapsedTime * Mathf.PI / moveTime) + 1) * toMoveX / 2.0f;
			float newY = initialY + (Mathf.Sin ((-Mathf.PI/2.0f) + elapsedTime * Mathf.PI / moveTime) + 1) * toMoveY / 2.0f;
			float newZ = initialZ + (Mathf.Cos ((-Mathf.PI/2.0f) + elapsedTime * Mathf.PI / moveTime)) * toMoveZ;
			transform.position = new Vector3 (newX, newY, newZ);
			
			if (elapsedTime >= moveTime)
			{
				moving = false;
				transform.position = new Vector3 (initialX+toMoveX, initialY+toMoveY, initialZ);
				toMoveX = 0;
				toMoveY = 0;
				toMoveZ = 0;
			}
		}
	}
	
	// Clic sur la case
	void OnMouseDown ()
	{
		if (!caseSelectionnee)
		{
			(gameObject.GetComponent("Halo") as Behaviour).enabled = true;
			caseSelectionnee = true;
			
			GameObject grille;
			grille = GameObject.Find("Grille");
			grille.SendMessage("SelectionCase", transform.position);
		}
		else
		{
			(gameObject.GetComponent("Halo") as Behaviour).enabled = false;
			caseSelectionnee = false;
		}
		
		// Test Move
		/*int moveX = Random.Range (-2, 2);
		int moveY = Random.Range (-2, 2);
		
		Move (moveX, moveY, 0, 0.2f);*/
	}
	
	void OnMouseEnter ()
	{
		(gameObject.GetComponent("Halo") as Behaviour).enabled = true;
	}
	
	void OnMouseExit ()
	{
		if (!caseSelectionnee)
			(gameObject.GetComponent("Halo") as Behaviour).enabled = false;
	}
	
	// dX : distance en x
	// dY : distance en y
	// dZ : distance en z
	// time : duree du mouvement
	public void Move (float dX, float dY, float dZ, float time)
	{
		moving = true;
		toMoveX = dX;
		toMoveY = dY;
		toMoveZ = dZ;
		initialX = transform.position.x;
		initialY = transform.position.y;
		initialZ = transform.position.z;
		moveTime = time;
		startTime = Time.time;
		
	}
	
	public void Selectionner()
	{
		(gameObject.GetComponent("Halo") as Behaviour).enabled = true;
		caseSelectionnee = true;
	}
	
	public void Deselectionner()
	{
		(gameObject.GetComponent("Halo") as Behaviour).enabled = false;
		caseSelectionnee = false;
	}
}
