using UnityEngine;
using System.Collections;

public class Interface : MonoBehaviour {
	
	
	
	
	public AudioClip explosion; 
	public AudioClip victoireFin;
	
	
	
	public static float timerLancer; 
	private float tempsLancement=2f;
	
	public GameObject perso;
	public GameObject[] tabPerso= new GameObject[10]; 
	
	
	
	public static GameObject persoActif;
	public int firstPersonnage;
	
	
	public GameObject ballon;
	public static GameObject mainActive;
	
	public GameObject ciblePerso;
	public GameObject cibleBallon;
	
	
	
	
	public static string etatBalle;
	public static int nombreVictoires;
	public static int scoreMax=3;
	public static float timerDelay;
	public static float timer;
	
	public GUIStyle styleCAR=new GUIStyle(); //compte à rebours
	public GUIStyle styleMenu=new GUIStyle(); //menu
	public GUIStyle styleExplode=new GUIStyle(); //explosion
	
	int centerH=Screen.width/2;
	int centerV=Screen.height/2;
	
	
	
	
	
	GameObject parcoursParent(string nom)
	{
		Transform objet;
		GameObject[] tabMain =GameObject.FindGameObjectsWithTag(nom);
		for(int i=0;i<tabMain.Length;i++)
		{
			objet=tabMain[i].transform;
			while(objet.transform.parent && objet.transform.name!="Joueurs")
			{
				
				objet=objet.transform.parent;
			}
			if(objet.transform.name==persoActif.transform.gameObject.name)
			{
				return tabMain[i];
			}
		}
		return null;
	}
	
	
	// Use this for initialization
	void Start () 
	{
		persoActif=tabPerso[firstPersonnage];
		//Camera.main.transform.parent=persoActif.transform;
		mainActive=parcoursParent("Main");
		
		
		etatBalle="Menu";
		
		
		
		styleCAR.fontSize=50;
		styleCAR.normal.textColor=new Color(1.0f,1.0f,1.0f);
		
		styleMenu.fontSize=50;
		styleMenu.normal.textColor=new Color(1.0f,1.0f,1.0f);
		
		styleExplode.fontSize=200;
		styleExplode.normal.textColor=new Color(0.0f,151.0f,0.0f);
		
	}
	
	// Update is called once per frame
	void Update () 
	{
		switch(etatBalle)
		{
			case "Menu":
				updateMenu();
				break;
			case "Initialisation" :
				updateInit();
				break;
			case "Victoire":
				updateVictoire();
				break;
			case "EnJeu":
				updateEnJeu();
				break;
			case "Score":
				updateScore();
				break;
			case "lance":
				updateLance();
				break;
			case "enMain":
				updateEnMain();
				break;
			
			default:
				break;
			
		}
	}
	
	void OnGUI () 
	{
		switch(etatBalle)
			{
			case "EnJeu":
				OnGUIEnJeu();
				break;
			case "Victoire":
				OnGUIVictoire();
				break;
			case "Score":
				OnGUIScore();
				break;
			case "Menu":
				OnGUIMenu();
				break;
			case "Difficulty":
				OnGUIDifficulty();
				break;
			case "Mort":
				OnGUIMort();
				break;
			case("Tuto") :
				onGUItuto();
				break;
		}
	}
	
	void OnGUIVictoire()
	{
		GUI.Label(new Rect(centerH-800/2,0,800,300),"BUUUUT",styleExplode);
		
		if (GUI.Button(new Rect(centerH-450/2,centerV-25,450,50), "Manche suivante",styleMenu))
		{
			etatBalle="Initialisation";
		}
	}
	
	void OnGUIEnJeu()
	{
		if(Input.GetKey(KeyCode.Escape))
		{
			nombreVictoires=0;
			
			etatBalle="Menu";
		}
		
		
		GUI.Label(new Rect(100,0,400,50),"Score : "+nombreVictoires+"/"+scoreMax+"",styleCAR);
		GUI.Label(new Rect(Screen.width-600,Screen.height-50,600,50),"Explosion dans : "+(int)(timer-Time.time+1)+" s",styleCAR);
		
		if(timer<Time.time && etatBalle=="EnJeu")
		{
			if(ballon.transform.parent!=null)
			{
				etatBalle="Mort";
				Camera.main.audio.PlayOneShot(explosion);
			}
			else
			{
				//Camera.main.audio.PlayOneShot(explosion);
				Camera.main.audio.PlayOneShot(explosion);
				timer=Time.time+timerDelay;;
				ballon.transform.position=cibleBallon.transform.position;	
			}
			
			
		}
		
		if(timer-Time.time<3)
		{
			styleCAR.normal.textColor=new Color(255.0f,0f,0f);
		}
		else
		{
			styleCAR.normal.textColor=new Color(255,255,255);
		}
		
		//flag de localisation
	}
	
	void OnGUIScore()
	{	
		GUI.Label(new Rect(100,0,300,50),"Score : "+nombreVictoires+"/"+scoreMax+"   Bravo ! Tu as fini la partie !");
		
		if (GUI.Button(new Rect(centerH-200/2,centerV-50,200,100), "Recommencer la partie",styleMenu))
		{
			nombreVictoires=0;
			etatBalle="Initialisation";
		}
		
		if (GUI.Button(new Rect(centerH-200/2,centerV+150,200,100), "Retour au menu",styleMenu))
		{
			nombreVictoires=0;
			etatBalle="Menu";
		}
	}
	
	void OnGUIMenu()
	{
		GUI.Label(new Rect(centerH-1200/2,0,1200,300),"BOMBERMAN",styleExplode);
		
		if (GUI.Button(new Rect(centerH-415/2,centerV-75,415,50), "Nouvelle partie",styleMenu))
		{
			etatBalle="Difficulty";
		}
		
		if (GUI.Button(new Rect(centerH-210/2,centerV+75,210,50), "Quitter",styleMenu))
		{
			Application.Quit();
			//fermeture du jeu
		}
		if(GUI.Button(new Rect(centerH-200/2,centerV-25,300,50),"Instructions",styleMenu))
		{
			etatBalle="Tuto";
		}
		
	}
	
	void OnGUIDifficulty()
	{	
		if (GUI.Button(new Rect(centerH-130/2,centerV-75,130,50), "Easy",styleMenu))
		{
			timerDelay=10.0f;
			etatBalle="Initialisation";
		}
		
		if (GUI.Button(new Rect(centerH-200/2,centerV+25,200,50), "Medium",styleMenu))
		{
			timerDelay=6.0f;
			etatBalle="Initialisation";
		}
		
		if (GUI.Button(new Rect(centerH-250/2,centerV+125,250,50), "Hardcore",styleMenu))
		{
			timerDelay=3.0f;
			etatBalle="Initialisation";
		}
	}
	
	void OnGUIMort()
	{
		//styleCAR.normal.textColor=new Color(1.0f,1.0f,1.0f);
		
		GUI.Label(new Rect(centerH-800/2,0,800,300),"BOOOOM",styleExplode);
		
		if (GUI.Button(new Rect(centerH-640/2,centerV-75,640,50), "Recommencer la manche",styleMenu))
		{
			etatBalle="Initialisation";
		}
		
		if (GUI.Button(new Rect(centerH-420/2,centerV+25,420,50), "Retour au menu",styleMenu))
		{
			nombreVictoires=0;
			etatBalle="Menu";
		}
	}
	
	
	
	
	
	
	
	void updateInit()
	{
		//apparition d'une nouvelle balle au centre
		timer=Time.time+timerDelay;
		ballon.transform.position=cibleBallon.transform.position;
		perso.transform.position=ciblePerso.transform.position;
		ballon.gameObject.AddComponent<Rigidbody>();
		ballon.gameObject.AddComponent<SphereCollider>();
		ballon.rigidbody.velocity=Vector3.zero;
		
		Interface.persoActif.transform.position=ciblePerso.transform.position;
		
		etatBalle="EnJeu";
	}
	
	void updateEnJeu()
	{
	
		
	}
	
	void updateScore()
	{
		//Musique Fin
	}
	
	void updateMenu()
	{
		//Musique Menu
	}
	
	
	void updateVictoire()
	{	
		if(nombreVictoires==scoreMax)
		{
			Camera.main.audio.PlayOneShot(victoireFin);
			etatBalle="Score";
		}
	}
	void updateLance()
	{
		
		if(timerLancer+tempsLancement<Time.time)
		{
			etatBalle="EnJeu";
		}
	}
	
	
	
	void updateEnMain()
	{
			
	}
	
	
	
	void onGUItuto()
	{
		GUI.Label(new Rect(100,100,1000,1000),"But du jeu : amener la bombe dans le camp ennemi !" +"\n"+
		"\n- Déplace le joueur actif à l'aide des flèches directionnelles et de la souris (viseur)" +
		"\n- Empare-toi de la bombe (marcher dessus suffit) et passe-la à un coequipier (clic gauche) avant la fin du compte à rebours" +
		"\n- Passer la balle à un coequipier redémarre le compte à rebours" +
		"\n- Tu peux zoomer avec la molette de la souris" +
		"\n- Les niveaux de difficulté influent sur la durée du compte à rebours !" +
		"\n- Méfie-toi des obstacles, c'est un coup à crever bêtement dans son trou...");
	}
	
		
		
	
}
