// Script issue de Lerpz 2D Tutorial. Modifié pour nos besoins.



// Adjusts the speed at which the static animation is played back
var staticAnimationSpeedModifier = 0.05;
// Adjusts the speed at which the walk animation is played back
var walkAnimationSpeedModifier = 0.4;
// Adjusts the speed at which the jump animation is played back
var jumpAnimationSpeedModifier = 1.0;

/




private var jumping = false;

function Start () {
	
	
	animation.Stop();

	// By default loop all animations
	animation.wrapMode = WrapMode.Loop;

	// Jump animation are in a higher layer:
	// Thus when a jump animation is playing it will automatically override all other animations until it is faded out.
	// This simplifies the animation script because we can just keep playing the walk / run / idle cycle without having to spcial case jumping animations.
	var jumpingLayer = 1;
	var jump = animation["saut"];
	jump.layer = jumpingLayer;
	jump.speed *= jumpAnimationSpeedModifier;
	jump.wrapMode = WrapMode.Once;
	
	var stati_c = animation["static"];
	stati_c.speed = staticAnimationSpeedModifier;
	
	var marche = animation["marche"];
	marche.speed = walkAnimationSpeedModifier;
	
	
}

function Update () {
	var controller : PlatformerController = GetComponent(PlatformerController);

			// Are we moving the character?
		if (controller.IsMoving())
		 {
				animation.CrossFade ("marche");
			}	
		// Go back to idle when not moving
		else
		{
								
			animation.CrossFade ("static", 0.5); 
			
	}

	}


function DidJump () {
	animation.Play ("saut");

}


