#pragma strict

//Développé par Anaël BELLE. Libre de droits.

var stem : Transform;
var flower : Transform;
var flow_arr : Transform;
var stem_arr : Transform;
var fireball : GameObject;
var spawnPoint : Transform;

var killAudio : AudioSource;


private var moveTimer : float = -3;
private var fireTimer : float = 0;
private var fireDelay : float = 4;
private var isActive : boolean = false;
private var isDead : boolean = false;

private var initRotation : Quaternion;

function Start () {
	initRotation = flower.rotation;
}

function Update () {

	if(!isActive && gameObject.collider.enabled == true){
		gameObject.collider.enabled = false;
	}
	
	if(!isActive 
	&& !isDead
	&& GameController.GetState() == GameController.State.START
	&& (GameController.PlayerPosition()-spawnPoint.position).magnitude < 10.0f){
		isActive = true;
		fireTimer = 1;
	}
	
	if(isActive && moveTimer < 0){
		flower.position=Vector3.Lerp(flower.position, flow_arr.position, Time.deltaTime);
		stem.position=Vector3.Lerp(stem.position, stem_arr.position, Time.deltaTime);
		moveTimer += Time.deltaTime;		
	}else if(isActive && (GameController.PlayerPosition()-spawnPoint.position).magnitude < 10.0f){
		gameObject.collider.enabled = true;		
		fireTimer -= Time.deltaTime;		
		if (fireTimer <= 0) {
			if(audio && !audio.isPlaying){
				audio.Play();
			}
			fireTimer = 4 + 0.1*Random.Range(0,11) - Random.Range(0,3) + Random.Range(0,3);
			var clone : GameObject;
	        clone = Instantiate(fireball, spawnPoint.position, spawnPoint.rotation); 
	        clone.rigidbody.velocity = spawnPoint.TransformDirection (Vector3.right * 3);
	        clone.rigidbody.angularVelocity = clone.transform.TransformDirection (Vector3.up * 3);
	        Destroy(clone,5);
		}
	//Gros probleme avec les eulerAngles de l'objet. Forcé de définir les lois 1 par 1.	
		
		var relativeUp = Vector3(-1,0,0);
		var relativePos = GameController.PlayerPosition() - flower.position;
		
		if (!isDead && (relativePos.x>0.5 || relativePos.x<-0.5) ){
			flower.rotation = Quaternion.LookRotation(relativePos,relativeUp);
		 	
		
			if(relativePos.y>=0 && relativePos.x<=0){
				flower.rotation.eulerAngles.z=0;
			}
			if(relativePos.y>=0 && relativePos.x>=0){
				flower.rotation.eulerAngles.z=180;
			}
			if(relativePos.y<=0 && relativePos.x<=0){
				flower.rotation.eulerAngles.z=0;
			}
			if(relativePos.y<=0 && relativePos.x>=0){
				flower.rotation.eulerAngles.z=180;
			}	
		}
	}
	
	if(isDead){
		flower.rotation = initRotation;
		flower.Translate(0.002f*Vector3.back);
		stem.Translate(0.002f*Vector3.back);
		//rigidbody.AddForce(100*rigidbody.mass*Vector3.up);
	}
}

function OnCollisionEnter(collision : Collision) {
	if(collision.gameObject.CompareTag("Bullet")){
		if(killAudio){
			killAudio.Play();
		}
		isActive = false;
		isDead = true;
		GameController.EnemyKilled();
		gameObject.collider.enabled = false;
		Destroy(gameObject,2);
		GameController.Gain(20);
	}
}